.586
.model flat,stdcall
option casemap:none

WinMain PROTO   :DWORD,:DWORD,:DWORD,:DWORD

include c:\masm32\include\windows.inc
include c:\masm32\include\kernel32.inc
include c:\masm32\include\user32.inc
include c:\masm32\include\comctl32.inc
include c:\masm32\include\gdi32.inc

includelib c:\masm32\lib\kernel32.lib
includelib c:\masm32\lib\user32.lib
includelib c:\masm32\lib\comctl32.lib
includelib c:\masm32\lib\gdi32.lib

.const

IDTimer equ     01h
.data

; ++++ Process Related Stuff ++++

hInstance       DWORD           ?
CommandLine     LPSTR           ?

; ++++ Main Window Vars & Others ++++

hMainWindow     dd              ?
MainWindowClass db              'MainWindowClass',0
MainWindowName  db              'Progress Bar Example',0
MainWindowWidth dd              400
MainWindowHeight        dd      150

; ++++ Progress Bar Vars & Others ++++

ProgressClass   db      'msctls_progress32',0
hProgress       dd      ?
ProgressWidth   dd      ?
ProgressHeight  dd      32
MaxRange        dw      0100h
MinRange        dw      0h
BarWidth        dd      ?

; ++++ Static Control related +++++

StaticClass     db      'STATIC',0
hStatic         dd      ?
PrActionOver    db      'Progress Action Over',0


; ++++ Misc Stuff ++++

DirFlag         dd      TRUE
rect            RECT    <>
MyTimer         dd      ?
hFont           dd         ?
hDC             HDC     ?

.code
        start:
                invoke  GetModuleHandle,NULL
                mov     hInstance,eax
                invoke  GetCommandLine
                mov     CommandLine,eax
                invoke  InitCommonControls
                invoke  WinMain,hInstance,NULL,CommandLine,SW_SHOWDEFAULT
                invoke  ExitProcess,eax

WinMain PROC    hInst:DWORD,hPrevInst:DWORD,CmdLine:DWORD,CmdShow:DWORD

        local   wc:WNDCLASSEX
        local   msg:MSG

        mov     wc.cbSize,sizeof wc
        mov     wc.style,CS_HREDRAW+CS_VREDRAW
        mov     wc.lpfnWndProc,offset WndProc
        mov     wc.lpszMenuName,NULL
        mov     wc.lpszClassName,offset MainWindowClass
        mov     wc.cbClsExtra,NULL
        mov     wc.cbWndExtra,NULL
        mov     wc.hbrBackground,COLOR_WINDOW
        push    hInst
        pop     wc.hInstance
        invoke  LoadIcon,NULL,IDI_APPLICATION
        mov     wc.hIcon,eax
        mov     wc.hIconSm,eax
        invoke  LoadCursor,NULL,IDC_ARROW
        mov     wc.hCursor,eax
        invoke  RegisterClassEx,addr wc
        invoke  CreateWindowEx,NULL,addr MainWindowClass,addr MainWindowName,WS_TILEDWINDOW,\
                NULL,NULL,MainWindowWidth,MainWindowHeight,NULL,NULL,hInstance,NULL
        mov     hMainWindow,eax
        invoke  ShowWindow,eax,SW_SHOWNORMAL
        invoke  UpdateWindow,hMainWindow

start_loop:
        invoke  GetMessage,addr msg,NULL,0,0
        cmp     eax,NULL
        je      end_loop
        invoke  TranslateMessage,addr msg
        invoke  DispatchMessage,addr msg
        jmp     start_loop
end_loop:
        mov     eax,msg.wParam
        ret

WinMain endp

WndProc PROC    hWnd:DWORD,uMsg:DWORD,wParam:DWORD,lParam:DWORD

        .if     uMsg==WM_DESTROY

                invoke  DestroyWindow,hProgress
                invoke  PostQuitMessage,NULL

        .elseif uMsg==WM_CREATE
        
                mov     edi,lParam
                assume  edi:PTR CREATESTRUCT
  
                 .if     [edi].hWndParent==NULL
                
                        invoke  GetClientRect,hWnd,addr rect
                        sub     rect.right,40
                        invoke  CreateWindowEx,WS_EX_CLIENTEDGE,addr ProgressClass,NULL,WS_VISIBLE+WS_CHILD,\
                                20,20,rect.right,ProgressHeight,hWnd,NULL,hInstance,NULL
                        mov     hProgress,eax
                        sub     rect.bottom,34
                        invoke  CreateWindowEx,WS_EX_STATICEDGE,addr StaticClass,NULL,WS_VISIBLE+WS_CHILD+SS_SIMPLE,\
                                20,rect.bottom,rect.right,32,hWnd,NULL,hInstance,NULL
                        mov     hStatic,eax
                        invoke  CreateFont,20,10,0,0,FW_DONTCARE,NULL,NULL,NULL,DEFAULT_CHARSET,OUT_DEFAULT_PRECIS,\
                                CLIP_DEFAULT_PRECIS,DEFAULT_QUALITY,FF_MODERN,NULL
                        mov     hFont,eax
                        invoke	SendMessage,hStatic,WM_SETFONT,hFont,TRUE                                                                                           
                        mov     ax,MaxRange
                        shl     eax,16
                        push    MinRange
                        pop     ax
                        invoke  SendMessage,hProgress,PBM_SETRANGE,NULL,eax
                        invoke  SetTimer,hWnd,IDTimer,010h,addr WndProc
                        mov     MyTimer,eax      
                .endif    
        .elseif uMsg==WM_TIMER
                        invoke  SendMessage,hProgress,PBM_GETPOS,NULL,NULL
                        
                        .if     ax>=MaxRange
                                invoke  KillTimer,hWnd,MyTimer
                                invoke  GetWindowRect,hStatic,addr rect
                                invoke  GetDC,hWnd
                                mov     hDC,eax
                                invoke  DrawText,hDC,addr PrActionOver,sizeof PrActionOver,addr rect,DT_CENTER
                                invoke  ReleaseDC,hWnd,hDC                                
                        .else                                
                                inc     eax
                                invoke  SendMessage,hProgress,PBM_SETPOS,eax,NULL                                                        
                        .endif
        .else

        invoke  DefWindowProc,hWnd,uMsg,wParam,lParam
        ret

.endif

xor     eax,eax
ret

WndProc endp

end     start                                       