.586
.model flat,stdcall
option casemap:none

WinMain PROTO   :DWORD,:DWORD,:DWORD,:DWORD

include c:\masm32\include\windows.inc
include c:\masm32\include\kernel32.inc
include c:\masm32\include\user32.inc
include c:\masm32\include\comctl32.inc

includelib c:\masm32\lib\kernel32.lib
includelib c:\masm32\lib\user32.lib
includelib c:\masm32\lib\comctl32.lib

.data

hInstance       DWORD           ?
CommandLine     LPSTR           ?

hMainWindow     dd              ?
MainWindowClass db              'MainWindowClass',0
MainWindowName  db              'TrackBar Example',0
MainWindowWidth dd              300
MainWindowHeight        dd      170

; ++++ Trackbar Stuff   ++++

hTrack          dd      ?
TrackbarClass   db      'msctls_trackbar32',0
MinRange        dw      0
MaxRange       dw       100

; ++++ Static Controls Stuff ++++

StaticClass     db      'STATIC',0
hStatic1        dd      ?
hStatic2        dd      ?
hStatic3        dd      ?
SlowString      db      'Slow',0
FastString      db      'Fast',0

; ++++ Tooltips Controls Stuff  ++++

SlowStrTip      db      'Rol Thum to this side to Slow up events',0
TooltipsClass   db      'Tooltips_class32',0
hTooltip         dd      ?
ti      TOOLINFO        <>
ToolClass       db      'TooltipClassName',0

iccx    INITCOMMONCONTROLSEX    <>
Err     db      'Error Creating tooltip control!',0
Creation        db      'Created Static control',0

.code
        start:
                invoke  GetModuleHandle,NULL
                mov     hInstance,eax
                invoke  GetCommandLine
                mov     CommandLine,eax
                mov     iccx.dwSize,sizeof iccx
                mov     iccx.dwICC,ICC_BAR_CLASSES+ICC_STANDARD_CLASSES
                invoke  InitCommonControlsEx,addr iccx
                invoke  WinMain,hInstance,NULL,CommandLine,SW_SHOWDEFAULT
                invoke  ExitProcess,eax

WinMain PROC    hInst:DWORD,hPrevInst:DWORD,CmdLine:DWORD,CmdShow:DWORD

        local   wc:WNDCLASSEX
        local   msg:MSG

        mov     wc.cbSize,sizeof wc
        mov     wc.style,CS_HREDRAW+CS_VREDRAW
        mov     wc.lpfnWndProc,offset WndProc
        mov     wc.lpszMenuName,NULL
        mov     wc.lpszClassName,offset MainWindowClass
        mov     wc.cbClsExtra,NULL
        mov     wc.cbWndExtra,NULL
        mov     wc.hbrBackground,COLOR_WINDOW
        push    hInst
        pop     wc.hInstance
        invoke  LoadIcon,NULL,IDI_APPLICATION
        mov     wc.hIcon,eax
        mov     wc.hIconSm,eax
        invoke  LoadCursor,NULL,IDC_ARROW
        mov     wc.hCursor,eax
        invoke  RegisterClassEx,addr wc
        invoke  CreateWindowEx,NULL,addr MainWindowClass,addr MainWindowName,WS_TILEDWINDOW,\
                NULL,NULL,MainWindowWidth,MainWindowHeight,NULL,NULL,hInstance,NULL
        mov     hMainWindow,eax
        invoke  ShowWindow,eax,SW_SHOWNORMAL
        invoke  UpdateWindow,hMainWindow

        .while  TRUE

                invoke  GetMessage,addr msg,NULL,0,0

        .break .if (!eax)

                invoke  TranslateMessage,addr msg
                invoke  DispatchMessage,addr msg

        .endw

        mov     eax,msg.wParam
        ret

WinMain endp

WndProc PROC    hWnd:DWORD,uMsg:DWORD,wParam:DWORD,lParam:DWORD

                local   wc:WNDCLASSEX
        
        .if     uMsg==WM_DESTROY

                invoke  PostQuitMessage,NULL
        .elseif uMsg==WM_CREATE
       
                mov     edi,lParam
                assume  edi:PTR CREATESTRUCT
                .if     [edi].hWndParent==NULL

                        invoke  CreateWindowEx,NULL,addr TrackbarClass,NULL,WS_VISIBLE+WS_CHILD+TBS_HORZ+TBS_AUTOTICKS+TBS_TOOLTIPS,\
                                        42,10,200,32,hWnd,NULL,hInstance,NULL
                        mov     hTrack,eax
                        invoke  CreateWindowEx,NULL,addr StaticClass,NULL,WS_VISIBLE+WS_CHILD+SS_SIMPLE,\
                                        0,40,300,32,hWnd,NULL,hInstance,NULL
                        mov     hStatic3,eax
                        invoke  CreateWindowEx,NULL,addr TooltipsClass,NULL,TTS_NOPREFIX+TTS_ALWAYSTIP,
                                                CW_USEDEFAULT,CW_USEDEFAULT,CW_USEDEFAULT,CW_USEDEFAULT,NULL,0100h,hInstance,NULL
                        mov     hTooltip,eax
                        invoke  SendMessage,hStatic2,WM_SETTEXT,NULL,addr Creation
                        cmp     eax,0
                        jne     next_1
                        invoke  SendMessage,hStatic3,WM_SETTEXT,NULL,addr Err
next_1:
                        invoke  SetWindowPos,hTooltip,HWND_TOPMOST,0,0,0,0,SWP_NOMOVE + SWP_NOSIZE + SWP_NOACTIVATE
                        mov     ti.cbSize,sizeof ti
                        mov     ti.uFlags,0
                        push    hStatic3
                        pop      ti.hWnd
                        mov     ti.uId,0
                        mov     ti.rect.left,5
                        mov     ti.rect.top,5
                        mov     ti.rect.right,100
                        mov     ti.rect.bottom,38
                        push    hInstance
                        pop      ti.hInst
                        mov     ti.lpszText,OFFSET SlowStrTip
                        invoke  SendMessage,hTooltip,TTM_ADDTOOL,NULL,addr ti
       ;                 invoke  SendMessage,hTooltip,TTM_ADDTOOL,NULL,addr ti
                        invoke  SendMessage,hTooltip,TTM_ACTIVATE,TRUE,NULL
                        mov     ax,MaxRange
                        shl       eax,16
                        mov     ax,MinRange
                        invoke  SendMessage,hTrack,TBM_SETRANGE,TRUE,eax
                        invoke  SendMessage,hTrack,TBM_SETTICFREQ,10,NULL
                        invoke  SendMessage,hTrack,TBM_SETTOOLTIPS,hTooltip,NULL
                        invoke  CreateWindowEx,NULL,addr StaticClass,NULL,WS_VISIBLE+WS_CHILD+SS_SIMPLE,\
                                        0,0,34,32,hWnd,NULL,hInstance,NULL
                        mov     hStatic1,eax
                        invoke  CreateWindowEx,NULL,addr StaticClass,NULL,WS_VISIBLE+WS_CHILD+SS_SIMPLE,\
                                        0,0,30,32,hWnd,NULL,hInstance,NULL
                        mov     hStatic2,eax


                        invoke  SendMessage,hStatic1,WM_SETTEXT,NULL,addr SlowString
                        invoke  SendMessage,hStatic2,WM_SETTEXT,NULL,addr FastString
                        invoke  SendMessage,hTrack,TBM_SETBUDDY,TRUE,hStatic1
                        invoke  SendMessage,hTrack,TBM_SETBUDDY,FALSE,hStatic2
                .endif

        .else

        
                invoke  DefWindowProc,hWnd,uMsg,wParam,lParam
                ret

        .endif

        xor     eax,eax
        ret

WndProc endp

end     start                                       