__UNICODE__ 	equ		TRUE
.586
.model flat,stdcall
option casemap:none

include \masm32\include\masm32rt.inc
include \masm32\asm\winclasses.asm

WinMain	PROTO	:DWORD,:DWORD,:DWORD,:DWORD
.const

MainWindowWidth	equ	600
MainWindowHeight	equ	500

IDB_CC	equ		100h
.data

hInstance	HINSTANCE	?
UCSTR		szMainWindowName,"Choose Color Common-dialog",0
wcMain	WNDCLASSEX	<sizeof wcMain,CS_HREDRAW+CS_VREDRAW,\
				offset WndProc,0,0,?,?,?,COLOR_WINDOW,\
				0,offset szMainWindowClass,0>
UCSTR		szMainWindowClass,"MainWindowClass",0
hMainWindow	HWND		?

; +++ Button related +++

hButton	HWND		?
UCSTR		szButtonName,"Choose Color",0

; +++ misc ++++

rect		RECT		<>
hDC		HDC		?
hBackDC	HDC		?

; +++ canvas related +++

hCanvas	HWND		?
UCSTR		szCanvasName,"Canvas",0
wcCanvas	WNDCLASSEX	<sizeof wcCanvas,CS_HREDRAW+CS_VREDRAW,\
				offset WndProc2,?,?,0,0,0,?,0,offset szCanvasClass,0>
UCSTR		szCanvasClass,"CanvasClass",0
ccolor	CHOOSECOLOR	<sizeof ccolor,0,0,0,0,0,0,0,0>
CustColors	dd 		0,0ffh,0ff00h,0ff0000h
		dd		40h,4000h,400000h
		dd		80h,8000h,800000h
		dd		0a0h,0a00h,0a0000h
		dd		0c0h,0c00h,0c0000h
point		POINT		<>
Buffer	dw		20 dup(0)
Buffer2	dw		20 dup(0)

.code
	start:
		invoke	GetModuleHandle,0
		mov		hInstance,eax
		invoke	WinMain,hInstance,0,0,SW_SHOWNORMAL
		invoke	ExitProcess,eax

WinMain	PROC	hInst:DWORD,hPrevInst:DWORD,CmdLine:DWORD,CmdShow:DWORD

	local	msg:MSG

	push	hInstance
	pop	wcMain.hInstance
	invoke	LoadIcon,0,IDI_APPLICATION
	mov	wcMain.hIcon,eax
	mov	wcMain.hIconSm,eax
	invoke	LoadCursor,0,IDC_ARROW
	mov	wcMain.hCursor,eax
	invoke	RegisterClassEx,addr wcMain
	invoke	GetSystemMetrics,SM_CYSCREEN
	shr		eax,1
	sub		eax,MainWindowHeight/2
	push		eax
	invoke	GetSystemMetrics,SM_CXSCREEN
	shr		eax,1
	sub		eax,MainWindowWidth/2
	pop		ebx
	invoke	CreateWindowEx,0,addr szMainWindowClass,\
			addr szMainWindowName,WS_OVERLAPPEDWINDOW,\
			eax,ebx,MainWindowWidth,MainWindowHeight,\
			0,0,hInst,0
	mov	hMainWindow,eax
	invoke	ShowWindow,eax,CmdShow
	invoke	UpdateWindow,hMainWindow

msg_loop:
	invoke	GetMessage,addr msg,NULL,0,0
	or	eax,eax
	jz	end_msg_loop
	invoke	TranslateMessage,addr msg
	invoke	DispatchMessage,addr msg
	jmp	msg_loop
end_msg_loop:
	mov	eax,msg.wParam
	ret

WinMain	endp

WndProc	PROC	hWnd:DWORD,uMsg:DWORD,wParam:DWORD,lParam:DWORD

	local	ps:PAINTSTRUCT
	
	.if	uMsg==WM_DESTROY
		invoke	PostQuitMessage,0
	.elseif	uMsg==WM_CREATE
		mov	edi,lParam
		.if	[edi.CREATESTRUCT.hWndParent]==0
			invoke	CreateWindowEx,0,addr WC_BUTTON,\
					addr szButtonName,WS_VISIBLE+WS_CHILD+\
					BS_PUSHBUTTON,0,0,100,32,\
					hWnd,IDB_CC,hInstance,0
			mov		hButton,eax
			invoke	GetClientRect,hWnd,addr rect
			sub		rect.bottom,34
			push		hInstance
			pop		wcCanvas.hInstance
			invoke	LoadCursor,hInstance,100
			mov		wcCanvas.hCursor,eax
			invoke	GetStockObject,WHITE_BRUSH
			mov		wcCanvas.hbrBackground,eax
			invoke	RegisterClassEx,addr wcCanvas
			invoke	CreateWindowEx,0,addr szCanvasClass,addr szCanvasName,\
					WS_VISIBLE+WS_CHILD,0,34,rect.right,\
					rect.bottom,hWnd,0,hInstance,0
			mov		hCanvas,eax
			push	hWnd
			pop	ccolor.hwndOwner
			push	hInstance
			pop	ccolor.hInstance
			mov	ccolor.Flags,CC_RGBINIT+CC_FULLOPEN
			mov	ccolor.lpCustColors,offset CustColors
			mov	ccolor.rgbResult,0ffh
		.endif
	.elseif	uMsg==WM_COMMAND
		mov	eax,wParam
		.if	ax==IDB_CC
			invoke	ChooseColor,addr ccolor
			invoke	CreatePen,PS_DOT,6,ccolor.rgbResult
			invoke	SelectObject,hBackDC,eax
			invoke	DeleteObject,eax
		.endif

	.else
		invoke	DefWindowProc,hWnd,uMsg,wParam,lParam
		ret
	.endif
	xor	eax,eax
	ret

WndProc	endp

WndProc2	PROC	hWnd:DWORD,uMsg:DWORD,wParam:DWORD,lParam:DWORD
	
	local	ps:PAINTSTRUCT
	local	hObject:DWORD
	local	lx:DWORD
	local	cy:DWORD

	.if	uMsg==WM_CREATE
		invoke	GetDC,hCanvas
		mov		hDC,eax
		invoke	CreateCompatibleDC,eax
		mov		hBackDC,eax
		invoke	CreateCompatibleBitmap,hDC,1000,1000
		mov		hObject,eax
		invoke	SelectObject,hBackDC,eax
		invoke	DeleteObject,eax
		invoke	ReleaseDC,hCanvas,hDC
		invoke	BitBlt,hBackDC,0,0,1000,1000,hBackDC,0,0,PATPAINT
		invoke	DeleteObject,hObject
		invoke	ReleaseDC,hWnd,hDC
	.elseif	uMsg==WM_MOUSEMOVE
		mov	eax,lParam
		mov	ebx,eax
		movzx	eax,ax
		shr	ebx,16
		mov	lx,eax
		mov	cy,ebx
			.if	wParam==MK_LBUTTON
				invoke	LineTo,hBackDC,eax,ebx
				mov		word ptr Buffer,0
				mov		word ptr Buffer2,0
				invoke	TextOut,hBackDC,0,400,cat$(offset Buffer,"x:",ustr$(lx)),6
				invoke	TextOut,hBackDC,40,400,cat$(offset Buffer2," y:",ustr$(cy)),6
				invoke	GetClientRect,hWnd,addr rect
				invoke	InvalidateRect,hWnd,addr rect,FALSE
			.else
				invoke	MoveToEx,hBackDC,eax,ebx,addr point
				mov	word ptr Buffer,0
				mov	word ptr Buffer2,0
				invoke	TextOut,hBackDC,0,400,cat$(offset Buffer,"x:",ustr$(lx)),6
				invoke	TextOut,hBackDC,40,400,cat$(offset Buffer2,"y:",ustr$(cy)),6
			.endif
	.elseif	uMsg==WM_PAINT
		invoke	BeginPaint,hWnd,addr ps
		mov		ecx,ps.rcPaint.right
		sub		ecx,ps.rcPaint.left
		mov		edx,ps.rcPaint.bottom
		sub		edx,ps.rcPaint.top
		invoke	BitBlt,ps.hdc,ps.rcPaint.left,ps.rcPaint.top,\
				ecx,edx,hBackDC,ps.rcPaint.left,ps.rcPaint.top,SRCCOPY
		invoke	EndPaint,hWnd,addr ps
	.else
		invoke	DefWindowProc,hWnd,uMsg,wParam,lParam
		ret
	.endif
	xor	eax,eax
	ret

WndProc2	endp
end	start

