.586    
.model flat,stdcall
option casemap:none

WinMain PROTO   :DWORD,:DWORD,:DWORD,:DWORD

include \masm32\include\windows.inc
include \masm32\include\kernel32.inc
include \masm32\include\user32.inc
include \masm32\include\comctl32.inc

includelib \masm32\lib\kernel32.lib
includelib \masm32\lib\user32.lib
includelib \masm32\lib\comctl32.lib

.const

MainWindowWidth     equ     600
MainWindowHeight    equ     350

.data

hInstance       dd      ?
hMainWindow     dd      ?
MainWindowClass db      'MainWindowClass',0
MainWindowName  db      'ComboBox Example',0

wc          WNDCLASSEX  <sizeof wc,CS_HREDRAW+CS_VREDRAW,offset WndProc,NULL,NULL,NULL, \
                        NULL,NULL,COLOR_WINDOW,NULL,offset MainWindowClass,NULL>
hCombo      dd      ?
ComboClass  db      'COMBOBOX',0
ROP2Strings     db      'R2_BLACK',0
                db      'R2_COPYPEN',0
                db      'R2_MASKNOTPEN',0
                db      'R2_MASKPEN',0
                db      'R2_MASKPENNOT',0
                db      'R2_MERGENOTPEN',0
                db      'R2_MERGEPEN',0
                db      'R2_MERGEPENNOT',0
                db      'R2_NOP',0
                db      'R2_NOT',0
                db      'R2_NOTCOPYPEN',0
                db      'R2_NOTMASKPEN',0
                db      'R2_NOTXORPEN',0
                db      'R2_WHITE',0
                db      'R2_XORPEN',0
                        
.code
    start:
        invoke  GetModuleHandle,NULL
        mov hInstance,eax
        invoke  InitCommonControls
        invoke  WinMain,hInstance,NULL,NULL,SW_SHOWNORMAL
        invoke  ExitProcess,eax

WinMain PROC    hInst:DWORD,hPInst:DWORD,CmdLine:DWORD,CmdShow:DWORD

    local   msg:MSG

    push    hInstance
    pop     wc.hInstance
    invoke  LoadIcon,NULL,IDI_APPLICATION
    mov     wc.hIcon,eax
    mov     wc.hIconSm,eax
    invoke  LoadCursor,NULL,IDC_ARROW
    mov     wc.hCursor,eax
    invoke  RegisterClassEx,addr wc
    invoke  GetSystemMetrics,SM_CYSCREEN
    shr     eax,1
    sub     eax,MainWindowHeight/2
    push    eax
    invoke  GetSystemMetrics,SM_CXSCREEN
    shr     eax,1
    sub     eax,MainWindowWidth/2
    pop     ebx
    invoke  CreateWindowEx,NULL,addr MainWindowClass,addr MainWindowName,WS_TILEDWINDOW,\   
               eax,ebx,MainWindowWidth,MainWindowHeight,NULL,NULL,hInstance,NULL
    mov     hMainWindow,eax
    invoke  ShowWindow,eax,CmdShow
    invoke  UpdateWindow,hMainWindow

msg_loop:
    invoke  GetMessage,addr msg,NULL,0,0
    or      eax,eax
    jz      end_msg_loop
    invoke  TranslateMessage,addr msg
    invoke  DispatchMessage,addr msg
    jmp     msg_loop
end_msg_loop:
    mov     eax,msg.wParam
    ret

WinMain     endp

WndProc PROC    hWnd:DWORD,uMsg:DWORD,wParam:DWORD,lParam:DWORD

    .if uMsg==WM_DESTROY
        invoke  PostQuitMessage,NULL
	.elseif	uMsg==WM_CREATE
		mov		edi,lParam
		.if	[edi.CREATESTRUCT].hWndParent==NULL
			invoke   CreateWindowEx,NULL,addr ComboClass,NULL,WS_VISIBLE+WS_CHILD+CBS_DROPDOWNLIST,\
                        0,0,100,100,hWnd,NULL,hInstance,NULL
                  mov       hCombo,eax
    
; adding the strings

    lea     esi,ROP2Strings
    mov     ecx,15
    cld
loop_1:
    push    ecx
    invoke  SendMessage,hCombo,CB_ADDSTRING,0,esi
    pop     ecx
    dec     ecx
    jcxz    end_loop_1
realign_1:
    lodsb
    cmp     al,0
    jne     realign_1
    jmp     loop_1

end_loop_1:
                                          
		.endif	        	
    .else
        invoke  DefWindowProc,hWnd,uMsg,wParam,lParam
        ret
    .endif
    xor eax,eax
    ret

WndProc     endp

end	start
