.586    
.model flat,stdcall
option casemap:none

WinMain PROTO   :DWORD,:DWORD,:DWORD,:DWORD
ToolbarProc PROTO   :DWORD,:DWORD,:DWORD,:DWORD

include \masm32\include\windows.inc
include \masm32\include\kernel32.inc
include \masm32\include\user32.inc
include \masm32\include\comctl32.inc

includelib \masm32\lib\kernel32.lib
includelib \masm32\lib\user32.lib
includelib \masm32\lib\comctl32.lib

.const

MainWindowWidth     equ     600
MainWindowHeight    equ     400

NoButtons           equ     5

.data

hInstance       dd      ?
hMainWindow     dd      ?
MainWindowClass db      'MainWindowClass',0
MainWindowName  db      'Toolbar tooltips',0

wc          WNDCLASSEX  <sizeof wc,CS_HREDRAW+CS_VREDRAW,offset WndProc,NULL,NULL,NULL, \
                        NULL,NULL,COLOR_WINDOW,NULL,offset MainWindowClass,NULL>
TBButtons       TBBUTTON        <0,0,TBSTATE_ENABLED,TBSTYLE_BUTTON,NULL,NULL>                        
                TBBUTTON        <0,1,TBSTATE_ENABLED,TBSTYLE_BUTTON,NULL,NULL>
                TBBUTTON        <0,2,TBSTATE_ENABLED,TBSTYLE_BUTTON,NULL,NULL>
                TBBUTTON        <0,3,TBSTATE_ENABLED,TBSTYLE_BUTTON,NULL,NULL>
                TBBUTTON        <0,4,TBSTATE_ENABLED,TBSTYLE_BUTTON,NULL,NULL>
ToolbarClass    db      'ToolbarWindow32',0
hToolbar        dd      ?
TooltipsClass   db      'tooltips_class32',0
hTooltips       dd      ?
sz1         db      'Button1',0
sz2         db      'Button2',0
sz3         db      'Button3',0
sz4         db      'Button4',0
sz5         db      'Button5',0
iccx        INITCOMMONCONTROLSEX    <sizeof iccx,ICC_BAR_CLASSES+ICC_TAB_CLASSES+ICC_COOL_CLASSES>
lpOldToolbarProc      dd          ?
TBId        dd          100h
TBRef       dd          ?
ReBarClass  db      'ReBarWindow32',0
hReBar      dd      ?
rbbi        REBARBANDINFO       <>
rect        RECT                <>

.code
    start:
        invoke  GetModuleHandle,NULL
        mov hInstance,eax
        invoke  InitCommonControlsEx,addr iccx
        invoke  WinMain,hInstance,NULL,NULL,SW_SHOWNORMAL
        invoke  ExitProcess,eax

WinMain PROC    hInst:DWORD,hPInst:DWORD,CmdLine:DWORD,CmdShow:DWORD

    local   msg:MSG

    push    hInstance
    pop     wc.hInstance
    invoke  LoadIcon,NULL,IDI_APPLICATION
    mov     wc.hIcon,eax
    mov     wc.hIconSm,eax
    invoke  LoadCursor,NULL,IDC_ARROW
    mov     wc.hCursor,eax
    invoke  RegisterClassEx,addr wc
    invoke  GetSystemMetrics,SM_CYSCREEN
    shr     eax,1
    sub     eax,MainWindowHeight/2
    push    eax
    invoke  GetSystemMetrics,SM_CXSCREEN
    shr     eax,1
    sub     eax,MainWindowWidth/2
    pop     ebx
    invoke  CreateWindowEx,NULL,addr MainWindowClass,addr MainWindowName,WS_TILEDWINDOW+\
                WS_CLIPCHILDREN+WS_CLIPSIBLINGS,\   
               eax,ebx,MainWindowWidth,MainWindowHeight,NULL,NULL,hInstance,NULL
    mov     hMainWindow,eax
    invoke  ShowWindow,eax,CmdShow
    invoke  UpdateWindow,hMainWindow

msg_loop:
    invoke  GetMessage,addr msg,NULL,0,0
    or      eax,eax
    jz      end_msg_loop
    invoke  TranslateMessage,addr msg
    invoke  DispatchMessage,addr msg
    jmp     msg_loop
end_msg_loop:
    mov     eax,msg.wParam
    ret

WinMain     endp

WndProc PROC    hWnd:DWORD,uMsg:DWORD,wParam:DWORD,lParam:DWORD

    local   ti:TOOLINFO
    
    .if uMsg==WM_DESTROY
        invoke  PostQuitMessage,NULL
    .elseif uMsg==WM_CREATE
        mov edi,lParam
        .if [edi.CREATESTRUCT].hWndParent==NULL
            invoke  CreateWindowEx,WS_EX_STATICEDGE,addr ToolbarClass,NULL,WS_VISIBLE+WS_CHILD+TBSTYLE_TOOLTIPS,\
                        0,0,200,32,hWnd,NULL,hInstance,NULL
            mov hToolbar,eax
            invoke  CreateWindowEx,WS_EX_TOOLWINDOW,addr TooltipsClass,NULL,WS_VISIBLE+WS_CHILD+TTS_ALWAYSTIP+WS_POPUP,\
                       CW_USEDEFAULT,CW_USEDEFAULT,CW_USEDEFAULT,CW_USEDEFAULT,hWnd,NULL,hInstance,NULL
            mov hTooltips,eax
            invoke  SendMessage,hToolbar,TB_SETTOOLTIPS,hTooltips,NULL                      
            invoke  SendMessage,hToolbar,TB_BUTTONSTRUCTSIZE,sizeof TBBUTTON,NULL
            invoke  SendMessage,hToolbar,TB_ADDBUTTONS,NoButtons,addr TBButtons
             mov ti.cbSize,sizeof ti
            push    hInstance
            pop     ti.hInst
            mov     ti.uFlags,TTF_CENTERTIP
            push    hToolbar
            pop     ti.hWnd
            lea     esi,sz1
            mov     ecx,5
            mov     ti.uId,0
            cld
looper:
            mov     ti.lpszText,esi
            push    ecx
            invoke  SendMessage,hToolbar,TB_GETITEMRECT,ti.uId,addr ti.rect
            invoke  SendMessage,hTooltips,TTM_ADDTOOL,NULL,addr ti
realign_loop:
            lodsb
            or      al,al
            jnz     realign_loop
            pop     ecx
            dec     ecx
            jcxz    end_looper
            inc     ti.uId
            jmp     looper
           
end_looper: 
        .endif                         
    .else
        invoke  DefWindowProc,hWnd,uMsg,wParam,lParam
        ret
    .endif
    xor eax,eax
    ret

WndProc     endp
                                            
end start