; +++++ Calendar Example +++++
; ++ programmed by Luis Costa ++
; ++++ xandaz@hotmail.com ++++


.586
.model flat,stdcall
option casemap:none

WinMain PROTO   :DWORD,:DWORD,:DWORD,:DWORD

include \masm32\include\windows.inc
include \masm32\include\kernel32.inc
include \masm32\include\user32.inc
include \masm32\include\comctl32.inc

includelib \masm32\lib\kernel32.lib
includelib \masm32\lib\user32.lib
includelib \masm32\lib\comctl32.lib

.const

MainWindowWidth         equ             400
MainWindowHeight        equ             300

.data

hInstance       DWORD           ?
CommandLine     LPSTR           ?

hMainWindow     dd              ?
MainWindowClass db              'MainWindowClass',0
MainWindowName  db              'Calendar Example',0

; ++++ Calendar related +++++

CalendarClass   db      'SysMonthCal32',0
hCalendar         dd                    ?

; ++++ Others +++++

rect                    RECT            <>

.code
        start:
                invoke  GetModuleHandle,NULL            ; Get the handle for the current module
                mov     hInstance,eax                         ; Store it
                invoke  GetCommandLine                    ; Get Command Line ( no really necessary here )
                mov     CommandLine,eax                   ; Store the pointer
                invoke  InitCommonControls                ; Initialize Common Control Library
                invoke  WinMain,hInstance,NULL,CommandLine,SW_SHOWDEFAULT
                invoke  ExitProcess,eax                       ; Exit process

WinMain PROC    hInst:DWORD,hPrevInst:DWORD,CmdLine:DWORD,CmdShow:DWORD

        local   wc:WNDCLASSEX                              ; Initialize WNDCLASSEX structure
        local   msg:MSG                                          ; Initialize MSG structure

        mov     wc.cbSize,sizeof wc                                             ; Sizeof WNDCLASSEX field   
        mov     wc.style,CS_HREDRAW+CS_VREDRAW                  ; Redraw horz/vert case changes made
        mov     wc.lpfnWndProc,offset WndProc                            ; Pointer to MainWindow Procedure
        mov     wc.lpszMenuName,NULL                                       ; No menu
        mov     wc.lpszClassName,offset MainWindowClass            ; MainWindow Class Name
        mov     wc.cbClsExtra,NULL                                              ; No ClsExtra
        mov     wc.cbWndExtra,NULL                                            ; Nor WndExtra allocation   
        mov     wc.hbrBackground,COLOR_WINDOW                      ; Background color brush
        push    hInst                                                                   ; Push module handle onto stack
        pop     wc.hInstance                                                        ; Store to WNDCLASSEX.hInstance field
        invoke  LoadIcon,NULL,IDI_APPLICATION                           ; Load system defined icon
        mov     wc.hIcon,eax                                                       ; Store to these WNDCLASSEX fields
        mov     wc.hIconSm,eax
        invoke  LoadCursor,NULL,IDC_ARROW                               ; Load System defined cursor
        mov     wc.hCursor,eax                                                    ; and Associate it with out window
        invoke  RegisterClassEx,addr wc                                       ; Register the class  
        invoke  GetSystemMetrics,SM_CYSCREEN                          ; Get Screen Height
        shr     eax,1                                                                    ; divide by 2
        sub     eax,MainWindowHeight/2                                       ; subtract WindowHeight/2 and we get top coordinate   
        push    eax                                                                     ; push  for later use
        invoke  GetSystemMetrics,SM_CXSCREEN                          ; Get Screen Width
        shr     eax,1                                                                   ; divide by 2 
        sub     eax,MainWindowWidth/2                                        ; subtract WindowWidth/2 and we get the left coordinate
        pop     ebx                                                                     ; pop   top coordinate to  ebx
        invoke  CreateWindowEx,NULL,addr MainWindowClass,addr MainWindowName,WS_TILEDWINDOW,\     ; Create the window
                eax,ebx,MainWindowWidth,MainWindowHeight,NULL,NULL,hInstance,NULL
        mov     hMainWindow,eax                                                 ; Store window handle
        invoke  ShowWindow,eax,SW_SHOWNORMAL                    ; Show Window
        invoke  UpdateWindow,hMainWindow                                ; Update Window

        .while  TRUE                                                                    ; Message Processing Loop

                invoke  GetMessage,addr msg,NULL,0,0

        .break .if (!eax)

                invoke  TranslateMessage,addr msg
                invoke  DispatchMessage,addr msg

        .endw

        mov     eax,msg.wParam
        ret

WinMain endp

WndProc PROC    hWnd:DWORD,uMsg:DWORD,wParam:DWORD,lParam:DWORD

        .if     uMsg==WM_DESTROY

                invoke  PostQuitMessage,NULL

        .elseif uMsg==WM_CREATE 
                mov     edi,lParam
                .if     [edi.CREATESTRUCT].hWndParent==NULL
                        invoke  GetClientRect,hWnd,addr rect                                                                                                    ; Get Client Area Rectangle
                        invoke  CreateWindowEx,WS_EX_STATICEDGE,addr CalendarClass,NULL,WS_VISIBLE+WS_CHILD,\           ; Create Calendar
                                rect.left,rect.top,rect.right,rect.bottom,hWnd,NULL,hInstance,NULL
                        mov     hCalendar,eax                                                                                                                          ; Store the Calendar handle
                .endif                                                                                                        

        .else

                invoke  DefWindowProc,hWnd,uMsg,wParam,lParam                                                                                       ; ensure every message is processed
                ret

        .endif

        xor     eax,eax
        ret

WndProc endp

end     start                                       