.586
.model flat,stdcall
option casemap:none

WinMain PROTO   :DWORD,:DWORD,:DWORD,:DWORD

include c:\masm32\include\windows.inc
include c:\masm32\include\kernel32.inc
include c:\masm32\include\user32.inc
include c:\masm32\include\comctl32.inc
include c:\masm32\include\gdi32.inc

includelib c:\masm32\lib\kernel32.lib
includelib c:\masm32\lib\user32.lib
includelib c:\masm32\lib\comctl32.lib
includelib c:\masm32\lib\gdi32.lib

.const

MainWindowWidth         equ     600
MainWindowHeight        equ     100

Button1ID               equ             0100h
Button2ID               equ             0101h
Button3ID               equ             0102h

.data

hInstance       DWORD           ?
CommandLine     LPSTR           ?

hMainWindow     dd              ?
MainWindowClass db              'MainWindowClass',0
MainWindowName  db              'Status Bar example',0

; ++++ Status bar related ++++

StatusClass     db      'msctls_statusbar32',0
hStatus         dd              ?
Widths          dd              20,42,-1
szStatus        db      'You inserted text into status bar',0

; ++++ Button related ++++

ButtonClass     db      'BUTTON',0
hButton1        dd              ?
hButton2        dd              ?
hButton3        dd              ?
szButton3       db      'Push this button to insert text into Status Bar',0
Button1Bmp      db      '.\btn1.ico',0
Button2Bmp      db      '.\btn2.ico',0
hBmp1           dd              ?
hBmp2           dd              ?
        
; ++++ Other Vars ++++

rect            RECT            <>
hDC             HDC             ?

.code
        start:
                invoke  GetModuleHandle,NULL
                mov     hInstance,eax
                invoke  GetCommandLine
                mov     CommandLine,eax
                invoke  InitCommonControls
                invoke  WinMain,hInstance,NULL,CommandLine,SW_SHOWDEFAULT
                invoke  ExitProcess,eax

WinMain PROC    hInst:DWORD,hPrevInst:DWORD,CmdLine:DWORD,CmdShow:DWORD

        local   wc:WNDCLASSEX
        local   msg:MSG

        mov     wc.cbSize,sizeof wc
        mov     wc.style,CS_HREDRAW+CS_VREDRAW
        mov     wc.lpfnWndProc,offset WndProc
        mov     wc.lpszMenuName,NULL
        mov     wc.lpszClassName,offset MainWindowClass
        mov     wc.cbClsExtra,NULL
        mov     wc.cbWndExtra,NULL
        mov     wc.hbrBackground,COLOR_WINDOW
        push    hInst
        pop     wc.hInstance
        invoke  LoadIcon,NULL,IDI_APPLICATION
        mov     wc.hIcon,eax
        mov     wc.hIconSm,eax
        invoke  LoadCursor,NULL,IDC_ARROW
        mov     wc.hCursor,eax
        invoke  RegisterClassEx,addr wc
        invoke  GetSystemMetrics,SM_CYSCREEN
        shr     eax,1
        sub     eax,MainWindowHeight/2
        push    eax
        invoke  GetSystemMetrics,SM_CXSCREEN
        shr     eax,1
        sub     eax,MainWindowWidth/2
        pop     ebx
        invoke  CreateWindowEx,NULL,addr MainWindowClass,addr MainWindowName,WS_TILEDWINDOW,\
                eax,ebx,MainWindowWidth,MainWindowHeight,NULL,NULL,hInstance,NULL
        mov     hMainWindow,eax
        invoke  ShowWindow,eax,SW_SHOWNORMAL
        invoke  UpdateWindow,hMainWindow

        .while  TRUE

                invoke  GetMessage,addr msg,NULL,0,0

        .break .if (!eax)

                invoke  TranslateMessage,addr msg
                invoke  DispatchMessage,addr msg

.endw

mov     eax,msg.wParam
ret

WinMain endp

WndProc PROC    hWnd:DWORD,uMsg:DWORD,wParam:DWORD,lParam:DWORD

        local   hBmp:DWORD
        local   MemDC:HDC
        
.if     uMsg==WM_DESTROY

        invoke  PostQuitMessage,NULL

.elseif uMsg==WM_CREATE
        mov     edi,lParam
        .if [edi.CREATESTRUCT].hWndParent==NULL
                invoke  GetClientRect,hWnd,addr rect
                invoke  CreateWindowEx,NULL,addr StatusClass,NULL,WS_VISIBLE+WS_CHILD+SBARS_SIZEGRIP,\
                                0,0,rect.right,0,hWnd,300h,hInstance,NULL
                mov     hStatus,eax
                invoke  SendMessage,hStatus,SB_SIMPLE,FALSE,NULL
                invoke  SendMessage,hStatus,SB_SETPARTS,3,addr Widths
                invoke  CreateWindowEx,NULL,addr ButtonClass,NULL,WS_VISIBLE+WS_CHILD+BS_PUSHBUTTON+BS_ICON,\
                                0,0,32,32,hWnd,Button1ID,hInstance,NULL
                mov     hButton1,eax
                invoke  CreateWindowEx,NULL,addr ButtonClass,NULL,WS_VISIBLE+WS_CHILD+BS_PUSHBUTTON+BS_ICON,\
                                32,0,32,32,hWnd,Button2ID,hInstance,NULL
                mov     hButton2,eax                                                
                invoke  GetClientRect,hWnd,addr rect
                sub     rect.right,64
                invoke  CreateWindowEx,NULL,addr ButtonClass,addr szButton3,WS_VISIBLE+WS_CHILD+BS_PUSHBUTTON+BS_TEXT,\
                                64,0,rect.right,32,hWnd,Button3ID,hInstance,NULL
                mov     hButton3,eax                                
                invoke  LoadImage,hInstance,addr Button1Bmp,IMAGE_ICON,30,30,LR_LOADFROMFILE
                invoke  SendMessage,hButton1,BM_SETIMAGE,IMAGE_ICON,eax
                invoke  LoadImage,hInstance,addr Button2Bmp,IMAGE_ICON,30,30,LR_LOADFROMFILE
                invoke  SendMessage,hButton2,BM_SETIMAGE,IMAGE_ICON,eax
                invoke  SendMessage,hStatus,SB_SETMINHEIGHT,20,NULL
                invoke  LoadImage,hInstance,addr Button1Bmp,IMAGE_ICON,18,18,LR_LOADFROMFILE                                
                mov     hBmp1,eax
                invoke  LoadImage,hInstance,addr Button2Bmp,IMAGE_ICON,18,18,LR_LOADFROMFILE                
                mov     hBmp2,eax
        .endif   
.elseif uMsg==WM_COMMAND
        mov     eax,wParam
        .if           ax==0100h
                invoke  SendMessage,hStatus,SB_SETICON,0,hBmp1
        .elseif      ax==101h
                invoke SendMessage,hStatus,SB_SETICON,1,hBmp2                                  
        .elseif     ax==0102h
                mov     eax,2
                or     eax,SBT_NOBORDERS
                invoke  SendMessage,hStatus,SB_SETTEXT,eax,addr szStatus
        .endif 
.else

                invoke  DefWindowProc,hWnd,uMsg,wParam,lParam
                ret

        .endif

        xor     eax,eax
        ret

WndProc endp

end     start                                       