; ++++ RichEdit Control Example ++++
; ++ Programmed by Luis Costa ++++++
; ++ Lisbon, 23 January, 2011 ++++++
; +++++++ xandaz@hotmail.com +++++++
.586    
.model flat,stdcall
option casemap:none

WinMain             PROTO   :DWORD,:DWORD,:DWORD,:DWORD
CreateControls      PROTO   :DWORD
Local_CreateMenu    PROTO   :DWORD
EditProc            PROTO   :DWORD,:DWORD,:DWORD,:DWORD,:DWORD,:DWORD
ToolbarProc         PROTO   :DWORD,:DWORD,:DWORD,:DWORD,:DWORD,:DWORD
ErrorReport         PROTO   :DWORD

include \masm32\include\windows.inc
include \masm32\include\kernel32.inc
include \masm32\include\user32.inc
include \masm32\include\comdlg32.inc
include \masm32\include\comctl32.inc
include \masm32\include\gdi32.inc


includelib \masm32\lib\kernel32.lib
includelib \masm32\lib\user32.lib
includelib \masm32\lib\comdlg32.lib
includelib \masm32\lib\comctl32.lib
includelib \masm32\lib\gdi32.lib

.const

MainWindowWidth     equ     600
MainWindowHeight    equ     350

NoButtons           equ     10

MaxAllocHandles     equ     10
ToolbarID	        equ     400h
TooltipID           equ     500h
RichEditID          equ     600h
NoToolbarTooltips   equ     8
.data

ALLOC_STRUCT    STRUCT

AllocHandle     dd      ?
lpAlloc         LPSTR   ?

ALLOC_STRUCT    ENDS

hInstance       dd      ?
CommandLine     LPSTR   ?
hMainWindow     dd      ?
MainWindowClass db      'MainWindowClass',0

MainWindowName  db      'Rich Edit Control Example v1.0',0

wc          WNDCLASSEX  <sizeof wc,CS_HREDRAW+CS_VREDRAW,offset WndProc,NULL,NULL,NULL, \
                        NULL,NULL,COLOR_WINDOW,NULL,offset MainWindowClass,NULL>
cxScreen        dd          ?
cyScreen        dd          ?

; ++++ Toolbar related +++++

hToolbar        dd          ?
ToolbarClass    db      'ToolbarWindow32',0
TBButtons       TBBUTTON    <0,0,TBSTATE_ENABLED,TBSTYLE_BUTTON,NULL,NULL>
                TBBUTTON    <1,1,TBSTATE_ENABLED,TBSTYLE_BUTTON,NULL,NULL>
                TBBUTTON    <2,2,TBSTATE_ENABLED,TBSTYLE_BUTTON,NULL,NULL>
                TBBUTTON    <NULL,NULL,TBSTATE_ENABLED,TBSTYLE_SEP,NULL,NULL>
                TBBUTTON    <3,3,TBSTATE_ENABLED,TBSTYLE_BUTTON,NULL,NULL>
                TBBUTTON    <4,4,TBSTATE_ENABLED,TBSTYLE_BUTTON,NULL,NULL>
                TBBUTTON    <5,5,TBSTATE_ENABLED,TBSTYLE_BUTTON,NULL,NULL>
                TBBUTTON    <6,6,TBSTATE_ENABLED,TBSTYLE_BUTTON,NULL,NULL>
                TBBUTTON    <NULL,NULL,TBSTATE_ENABLED,TBSTYLE_SEP,NULL,NULL>
                TBBUTTON    <7,7,TBSTATE_ENABLED,TBSTYLE_BUTTON,NULL,NULL>
ToolbarReservedY        dd          ?
lpOldToolbarProc        dd          ?

ToolbarStrings   LABEL   DWORD
szNew   db      'New',0
szOpen  db      'Open',0
szSave  db      'Save',0
CopyString  db      'Copy',0
PasteString db      'Paste',0
UndoString  db      'Undo',0
RedoString  db      'Redo',0
ExitString  db      'Exit',0
iButton     dd          0
NullString  db          0

; ++++ Tooltips related +++++

TooltipClass    db      'tooltips_class32',0
hTooltips       dd              ?
ti          TOOLINFO        <>

; ++++ RichEdit related +++++

szRichEdit      db      'riched20.dll',0
hRichEditLib    dd          ?
RichEditClass   db      'RichEdit20A',0
hRichEdit       dd          ?
lpOldEditProc   dd          ?
StreamStruct    EDITSTREAM  <0,0,offset StreamInProc>
SelFirst        dd          ?
SelLast         dd          ?
cf2         CHARFORMAT2     <sizeof cf2,CFM_COLOR+CFM_SIZE+CFM_FACE,CFE_SHADOW+CFE_DISABLED,200,NULL,0ff0000h,DEFAULT_CHARSET,NULL,\
                            'Arial',10,20,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL>
stex        SETTEXTEX       <>
szCommDlg   db          'comdlg32.dll',0
hCommDlgLib dd          ?

; ++++ Others +++++

rect        RECT        <>
pt          POINT       <>
szFile      db      '.\re2.asm',0
hFile       dd          ?
ofn         OPENFILENAME    <sizeof ofn,?,?,offset szFilters,NULL,NULL,NULL,offset szFileName,256,offset szFileTitle\
                            ,256,NULL,?,OFN_FILEMUSTEXIST+OFN_EXPLORER,?,?,?,?,?,?>
szFilters   db      'Assembly Source file',0,'*.asm',0,'Text File',0,'*.txt',0,0
CustomFilters     db      256 dup(0)
szFileName        db      256 dup(0)
szFileTitle       db      256 dup(0)                 
ovl         OVERLAPPED      <>
                                             
; ++++ Error reporting +++++

szError     db      'Error!!!',0
szErrorIHV  db      'CreateFile returned INVALID_HANDLE_VALUE',0
szErrorCLL  db      'Couldnt Load RichEdit Library',0
szErrorAllocExceed    db      'Number of Selections Exceeded / Cant UNDO',0
szErrorNoSelection    db      'Nothing previously selected/ cant paste!',0
szErrorFileCreate     db      'Couldnt create file',0
szErrorFileLoad       db      'Couldnt Load File',0
szErrorMemFree        db      'Couldnt free allocated memory!',0
szErrorMemUnlock      db      'Couldnt unlock allocated memory',0

; +++++ Menu related +++++

hMenu       dd          ?

AllocHandles    ALLOC_STRUCT 10 dup(<0,0>)
lpAllocHandles  dd  offset AllocHandles
NoAllocHandles  dd  0
AllocHandle     DWORD       ?
lpAlloc         DWORD       ?
hHeap           dd          ?
iccx        INITCOMMONCONTROLSEX    <sizeof iccx,ICC_BAR_CLASSES+ICC_STANDARD_CLASSES>    


.code
    start:
        invoke  GetModuleHandle,NULL
        mov     hInstance,eax
        invoke  GetCommandLine
        mov     CommandLine,eax
        invoke  InitCommonControlsEx,addr iccx
        invoke  WinMain,hInstance,NULL,NULL,SW_SHOWDEFAULT
        invoke  ExitProcess,eax

WinMain PROC    hInst:DWORD,hPInst:DWORD,CmdLine:DWORD,CmdShow:DWORD

    local   msg:MSG

    push    hInstance
    pop     wc.hInstance
    invoke  LoadIcon,NULL,IDI_APPLICATION
    mov     wc.hIcon,eax
    mov     wc.hIconSm,eax
    invoke  LoadCursor,NULL,IDC_ARROW
    mov     wc.hCursor,eax
    invoke  RegisterClassEx,addr wc
    invoke  GetSystemMetrics,SM_CYSCREEN
    mov     cyScreen,eax
    shr     eax,1
    sub     eax,MainWindowHeight/2
    push    eax
    invoke  GetSystemMetrics,SM_CXSCREEN
    mov     cxScreen,eax
    shr     eax,1
    sub     eax,MainWindowWidth/2
    pop     ebx
    invoke  CreateWindowEx,NULL,addr MainWindowClass,addr MainWindowName,WS_TILEDWINDOW+WS_CLIPCHILDREN,\;+WS_CLIPSIBLINGS,\   
               eax,ebx,MainWindowWidth,MainWindowHeight,NULL,NULL,hInstance,NULL
    mov     hMainWindow,eax
    invoke  ShowWindow,eax,SW_SHOWNORMAL
    invoke  UpdateWindow,hMainWindow

msg_loop:
    invoke  GetMessage,addr msg,NULL,0,0
    or      eax,eax
    jz      end_msg_loop
    invoke  TranslateMessage,addr msg
    invoke  DispatchMessage,addr msg
    jmp     msg_loop
end_msg_loop:
    mov     eax,msg.wParam
    ret

WinMain     endp

WndProc PROC    uses esi edi hWnd:DWORD,uMsg:DWORD,wParam:DWORD,lParam:DWORD

    local   TempBuffer[1024]:BYTE

        
    .if uMsg==WM_DESTROY
Quit_App:    
        invoke  PostQuitMessage,NULL
    .elseif uMsg==WM_CREATE
        mov edi,lParam
        .if [edi.CREATESTRUCT].hwndParent==NULL
            invoke  CreateControls,hWnd
            push    hWnd
            pop     ofn.hwndOwner
            push    hInstance
            pop     ofn.hInstance  
            invoke  GetProcessHeap
            mov     hHeap,eax              

        .endif         
    .elseif uMsg==WM_SIZE
            invoke  SendMessage,hToolbar,TB_AUTOSIZE,NULL,NULL
            mov     eax,lParam
            push    eax
            movzx   eax,ax
            pop     ebx
            shr     ebx,16
            sub     ebx,ToolbarReservedY
            invoke  MoveWindow,hRichEdit,0,ToolbarReservedY,eax,ebx,TRUE
  
    .elseif uMsg==WM_COMMAND
        mov eax,wParam
        rol eax,16
        .if ax!=EN_UPDATE || EN_SELCHANGE || EN_CHANGE
            ror eax,16
                .if ax==0
                    invoke  SendMessage,hRichEdit,WM_SETTEXT,NULL,addr NullString
                .elseif ax==1
                    mov     ofn.lpstrTitle,offset szOpen
                    invoke  SendMessage,hRichEdit,EM_GETMODIFY,NULL,NULL
                    .if     eax==FALSE
                        jmp next_op
                    .else
                        invoke  SetFilePointer,hFile,NULL,NULL,FILE_BEGIN
                        mov     StreamStruct.pfnCallback,offset StreamOutProc
                        push    hFile
                        pop     StreamStruct.dwCookie
                        invoke  SendMessage,hRichEdit,EM_STREAMOUT,SF_TEXT,addr StreamStruct
                        invoke  SetEndOfFile,hFile
next_op:                                           
                        invoke  GetOpenFileName,addr ofn
                        .if eax==NULL
                            jmp     end_command_open
                        .else
                        invoke  CloseHandle,hFile
                        invoke  CreateFile,ofn.lpstrFileTitle,GENERIC_READ+GENERIC_WRITE,
                                    NULL,NULL,OPEN_EXISTING,\
                                    FILE_ATTRIBUTE_NORMAL,NULL
                               .if eax!=NULL                            
                                   mov     hFile,eax
                                   mov     StreamStruct.dwCookie,eax
                                   mov     StreamStruct.pfnCallback,offset StreamInProc                            
                                   invoke  SendMessage,hRichEdit,EM_STREAMIN,SF_TEXT,addr StreamStruct
                                   invoke  SendMessage,hRichEdit,EM_SETMODIFY,FALSE,NULL
                               .else
                                   invoke  MessageBox,hWnd,addr szErrorFileLoad,addr szError,MB_OK                                                           
                               .endif
                        .endif
                    .endif    
end_command_open:                    
                    .elseif ax==2
                        mov     ofn.lpstrTitle,offset szSave
                        invoke  GetSaveFileName,addr ofn
                        invoke  CreateFile,ofn.lpstrFileTitle,GENERIC_WRITE,FILE_SHARE_READ+FILE_SHARE_WRITE+FILE_SHARE_DELETE\
                                                ,NULL,CREATE_ALWAYS,FILE_ATTRIBUTE_NORMAL,NULL
                        .if eax!=NULL                        
                                mov hFile,eax
                                mov StreamStruct.dwCookie,eax
                                mov StreamStruct.pfnCallback,offset StreamOutProc
                                invoke  SendMessage,hRichEdit,EM_STREAMOUT,SF_TEXT,addr StreamStruct
                        .else
                            invoke  MessageBox,hWnd,addr szErrorFileCreate,addr szError,MB_OK
                        .endif     
                                         
                    .elseif ax==3
                        .if NoAllocHandles<MaxAllocHandles
                            mov     edi,lpAllocHandles
                            cld
                            invoke  SendMessage,hRichEdit,EM_GETSEL,addr SelFirst,addr SelLast
                            mov     eax,SelLast
                            sub     eax,SelFirst
                            invoke  LocalAlloc,LPTR,eax
                            mov     AllocHandle,eax
                            stosd
                            invoke  LocalLock,eax
                            stosd
                            mov     lpAlloc,eax
                            invoke  SendMessage,hRichEdit,EM_GETSELTEXT,NULL,eax
                            mov     lpAllocHandles,edi
                            inc     NoAllocHandles
                        .else
                            invoke  MessageBox,hMainWindow,addr szErrorAllocExceed,addr szError,MB_OK
                        .endif                                            
        
                    .elseif ax==4

                        .if NoAllocHandles>0
                            mov     stex.flags,ST_KEEPUNDO+ST_SELECTION
                            mov     stex.codepage,860
                            mov     esi,lpAllocHandles
                            sub     esi,8
                            cld
                            lodsd
                            mov     AllocHandle,eax
                            lodsd
                            mov     lpAlloc,eax
                            invoke  SendMessage,hRichEdit,EM_SETTEXTEX,addr stex,eax
                            sub     esi,8
                            mov     lpAllocHandles,esi
                            dec     NoAllocHandles
                            invoke  LocalFree,AllocHandle
                            .if     eax==NULL
                                invoke  MessageBox,hWnd,addr szErrorMemFree,addr szError,MB_OK
                            .endif                                
                        .else
                            invoke  MessageBox,hMainWindow,addr szErrorNoSelection,addr szError,MB_OK
                        .endif                                            
        
                    .elseif ax==5
                        invoke  SendMessage,hRichEdit,EM_UNDO,NULL,NULL
                    .elseif ax==6
                        invoke  SendMessage,hRichEdit,EM_REDO,NULL,NULL
                    .elseif ax==7
                        invoke  PostQuitMessage,NULL
            .endif           
        .endif            
    .elseif  uMsg==WM_CHAR 
          invoke  SendMessage,hWnd,EM_SETMODIFY,TRUE,NULL                    
        
    .else
        invoke  DefWindowProc,hWnd,uMsg,wParam,lParam
        ret         
    .endif
    xor eax,eax
    ret

WndProc     endp

StreamInProc    PROC    dwCookie:DWORD,lpBuff:DWORD,cb:DWORD,pcb:DWORD
    
    invoke  ReadFile,dwCookie,lpBuff,cb,pcb,NULL
    xor eax,1
    ret

StreamInProc    endp

StreamOutProc   PROC    dwCookie:DWORD,lpBuff:DWORD,cb:DWORD,pcb:DWORD

    invoke  WriteFile,dwCookie,lpBuff,cb,pcb,NULL
    xor     eax,1
    ret
    
StreamOutProc   endp

SetImageList    PROC

    local   hList:DWORD
    local   hBitmap:DWORD,hBitmapMask:DWORD
    
    invoke  ImageList_Create,24,24,ILC_COLOR32+ILC_MASK,7,7
    mov     hList,eax
    invoke  SendMessage,hToolbar,TB_SETIMAGELIST,NULL,hList
    mov     edi,100
    mov     ecx,8
looper:
    push    ecx
    invoke  LoadImage,hInstance,edi,IMAGE_BITMAP,24,24,LR_SHARED
    mov     hBitmap,eax
    inc     edi
    invoke  LoadImage,hInstance,edi,IMAGE_BITMAP,24,24,LR_SHARED
    mov     hBitmapMask,eax
    inc     edi
    invoke  ImageList_Add,hList,hBitmap,hBitmapMask
    invoke  DeleteObject,hBitmap
    invoke  DeleteObject,hBitmapMask
    pop     ecx
    dec     ecx
    jcxz    end_looper
    jmp     looper
end_looper:
    ret

SetImageList    endp        
    
Local_CreateMenu    PROC    hWnd:DWORD

    local   mii:MENUITEMINFO
    
    invoke  CreatePopupMenu
    mov     hMenu,eax
    invoke  SetMenu,hWnd,hMenu
    mov mii.cbSize,sizeof mii
    mov mii.fMask,MIIM_TYPE+MIIM_ID
    mov mii.fType,MFT_STRING
    mov mii.wID,3
    mov mii.dwTypeData,offset CopyString
    invoke  InsertMenuItem,hMenu,1,TRUE,addr mii
    inc mii.wID
    mov mii.dwTypeData,offset PasteString
    invoke  InsertMenuItem,hMenu,2,TRUE,addr mii
    inc mii.wID
    mov mii.dwTypeData,offset UndoString
    invoke  InsertMenuItem,hMenu,3,TRUE,addr mii
    inc mii.wID
    mov mii.dwTypeData,offset RedoString
    invoke  InsertMenuItem,hMenu,4,TRUE,addr mii
    ret

Local_CreateMenu    endp

EditProc    PROC    hWnd:DWORD,uMsg:DWORD,wParam:DWORD,lParam:DWORD,REId:DWORD,RERef:DWORD

    .if uMsg==WM_RBUTTONDOWN
            invoke  Beep,200,20
            invoke  GetCursorPos,addr pt
            invoke  GetClientRect,hWnd,addr rect
            invoke  TrackPopupMenu,hMenu,TPM_RIGHTALIGN+TPM_RIGHTBUTTON,pt.x,pt.y,NULL,hWnd,addr rect
            
    .elseif uMsg==WM_COMMAND 
        push    esi
        push    edi           
        mov eax,wParam
 
            .if ax==3
                .if NoAllocHandles<MaxAllocHandles
                        mov     edi,lpAllocHandles
                        cld
                        invoke  SendMessage,hRichEdit,EM_GETSEL,addr SelFirst,addr SelLast
                        mov     eax,SelLast
                        sub     eax,SelFirst
                        invoke  LocalAlloc,LPTR,eax 
                        mov     AllocHandle,eax
                        stosd
                        invoke  LocalLock,eax
                        stosd
                        mov     lpAlloc,eax
                        invoke  SendMessage,hWnd,EM_GETSELTEXT,NULL,eax
                        mov     lpAllocHandles,edi
                        inc     NoAllocHandles
                .else
                    invoke  MessageBox,hMainWindow,addr szErrorAllocExceed,addr szError,MB_OK
                .endif                                            
            .elseif ax==4
                .if NoAllocHandles>0
                        mov     stex.flags,ST_KEEPUNDO+ST_SELECTION
                        mov     stex.codepage,860
                        mov     esi,lpAllocHandles
                        sub     esi,8
                        cld
                        lodsd
                        mov     AllocHandle,eax
                        lodsd
                        mov     lpAlloc,eax
                        invoke  SendMessage,hWnd,EM_SETTEXTEX,addr stex,eax
                        sub     esi,8
                        mov     lpAllocHandles,esi
                        dec     NoAllocHandles
                        invoke  LocalFree,AllocHandle
                .else
                    invoke  MessageBox,hMainWindow,addr szErrorNoSelection,addr szError,MB_OK
                .endif                                            
                                                                                    
            .elseif ax==5
                invoke  SendMessage,hWnd,EM_UNDO,NULL,NULL
            .elseif ax==6
                invoke  SendMessage,hWnd,EM_REDO,NULL,NULL                
            .endif       
        pop     edi
        pop     esi
    .elseif uMsg==WM_CHAR
        invoke  SendMessage,hWnd,EM_SETMODIFY,TRUE,NULL
    .else

no_button:        
    .endif    
    invoke  DefSubclassProc,hWnd,uMsg,wParam,lParam
    ret
                
EditProc    endp

CreateControls  PROC    hWnd:DWORD

                local   TB:TBBUTTON
                local   TBId:DWORD,TBRef:DWORD
                
                invoke  LoadLibrary,addr szRichEdit
            .if eax!=NULL

                mov     hRichEditLib,eax
                invoke  LoadLibrary,addr szCommDlg
                mov     hCommDlgLib,eax
                invoke  CreateWindowEx,WS_EX_STATICEDGE,addr ToolbarClass,NULL,WS_VISIBLE+WS_CHILD+TBSTYLE_FLAT,\
                            0,0,0,0,hWnd,NULL,hInstance,NULL
                mov     hToolbar,eax
                call    SetImageList
                invoke  SendMessage,eax,TB_BUTTONSTRUCTSIZE,sizeof TBBUTTON,NULL
                invoke  SendMessage,hToolbar,TB_ADDBUTTONS,NoButtons,addr TBButtons
                invoke	SendMessage,hToolbar,TB_AUTOSIZE,NULL,NULL    
                invoke  CreateWindowEx,WS_EX_TOOLWINDOW,addr TooltipClass,NULL,WS_POPUP+WS_VISIBLE+WS_CHILD+TTS_ALWAYSTIP\
                            ,CW_USEDEFAULT,CW_USEDEFAULT,CW_USEDEFAULT,CW_USEDEFAULT,hWnd,NULL,hInstance,NULL
                mov     hTooltips,eax  
                mov     ti.cbSize,sizeof ti
                mov     ti.uFlags,TTF_CENTERTIP
                push    hToolbar
                pop     ti.hWnd
                push    hInstance
                pop     ti.hInst
                lea     esi,ToolbarStrings
                mov     ecx,NoToolbarTooltips
                cld
                push    hInstance
                pop     ti.hInst
loop_1:                
                mov     ti.lpszText,esi
                push    ecx
                invoke  SendMessage,hToolbar,TB_GETITEMRECT,iButton,addr ti.rect
                invoke  SendMessage,hTooltips,TTM_ADDTOOL,NULL,addr ti
realign_loop:                
                lodsb   
                cmp     al,0
                jne     realign_loop
                inc     iButton
                inc     ti.uId
                pop     ecx
                dec     ecx
                jcxz    end_loop_1
                jmp     loop_1
end_loop_1:                
                invoke  SendMessage,hToolbar,TB_SETTOOLTIPS,hTooltips,NULL
                invoke  GetClientRect,hWnd,addr rect
                invoke  GetSystemMetrics,SM_CYEDGE
                shl     eax,1
                push    eax
                invoke  SendMessage,hToolbar,TB_GETBUTTONSIZE,NULL,NULL
                pop     ebx
                shr     eax,16
                add     eax,ebx
                add     eax,2
                mov     ToolbarReservedY,eax
                add     rect.top,eax
                sub     rect.bottom,eax
                invoke  CreateWindowEx,NULL,addr RichEditClass,NULL,WS_VISIBLE+WS_CHILD+WS_CLIPSIBLINGS+ES_MULTILINE+ES_WANTRETURN\
                         +WS_HSCROLL+WS_VSCROLL,0,rect.top,rect.right,rect.bottom,hWnd,RichEditID,hInstance,NULL
                mov     hRichEdit,eax
                invoke  SetWindowSubclass,hRichEdit,addr EditProc,NULL,NULL
                invoke  Local_CreateMenu,hRichEdit
                invoke  SendMessage,hRichEdit,EM_EMPTYUNDOBUFFER,0,0
                invoke  SendMessage,hRichEdit,EM_SETCHARFORMAT,SCF_ALL,addr cf2
            .else
                invoke  MessageBox,hWnd,addr szErrorCLL,addr szError,MB_OK
                invoke  PostQuitMessage,NULL
            .endif
            ret
            
CreateControls  endp

ErrorReport     PROC    lpMsg:DWORD

    invoke  MessageBox,hMainWindow,lpMsg,addr szError,MB_OK
    ret

ErrorReport     endp

end start                                            
