; ++++ Simple Registry Enumrator ++++
; ++++ Programmed by Luis Costa +++++
; +++++++ Lisbon,Portugal +++++++++++
; +++++++ xandaz@hotmail.com ++++++++

.586    
.model flat,stdcall
option casemap:none

WinMain                 PROTO   :DWORD,:DWORD,:DWORD,:DWORD
FillSubLevel            PROTO   :DWORD
FillListViewControl     PROTO   :DWORD
CopyStringAddBar        PROTO   :DWORD,:DWORD
AddString               PROTO   :DWORD,:DWORD
MyInsertItem              PROTO   :DWORD,:DWORD,:DWORD,:DWORD,:DWORD

include \masm32\include\windows.inc
include \masm32\include\kernel32.inc
include \masm32\include\user32.inc
include \masm32\include\comctl32.inc
include \masm32\include\advapi32.inc
include \masm32\include\shlwapi.inc

includelib \masm32\lib\kernel32.lib
includelib \masm32\lib\user32.lib
includelib \masm32\lib\comctl32.lib
includelib \masm32\lib\advapi32.lib
includelib \masm32\lib\shlwapi.lib

.const

MainWindowWidth     equ     600
MainWindowHeight    equ     350

TreeViewID          equ     100h
ListViewID          equ     200h
NoSystemKeys        equ     7
NoValueTypes        equ     11
.data

hInstance       dd      ?
hMainWindow     dd      ?
MainWindowClass db      'MainWindowClass',0
MainWindowName  db      'Registry Viewer v1.0',0
wc          WNDCLASSEX  <sizeof wc,CS_HREDRAW+CS_VREDRAW,offset WndProc,NULL,NULL,NULL, \
                        NULL,NULL,COLOR_WINDOW,NULL,offset MainWindowClass,NULL>

; ++++ TreeView related ++++

TreeViewClass       db      'SysTreeView32',0
hTreeView           dd      ?
tvis        TV_INSERTSTRUCT     <>
tvi         TV_ITEM             <>
tvBuffer    db      256 dup(0)
hParent     dd      ?
; ++++ ListView related ++++

ListViewClass       db      'SysListView32',0
hListView           dd      ?
lvi         LV_ITEM             <>
lvc         LV_COLUMN           <>
ColName     db      'Name',0
ColType     db      'Type',0
ColData     db      'Data',0

; ++++ Static related ++++

hStatic     dd      ?
StaticClass db      'STATIC',0

; ++++ Registry related ++++

SystemKeys      dd      HKEY_CLASSES_ROOT
                db      'HKEY_CLASSES_ROOT',0
                dd      HKEY_CURRENT_USER
                db      'HKEY_CURRENT_USER',0
                dd      HKEY_LOCAL_MACHINE
                db      'HKEY_LOCAL_MACHINE',0
                dd      HKEY_USERS
                db      'HKEY_USERS',0
                dd      HKEY_PERFORMANCE_DATA
                db      'HKEY_PERFORMANCE_DATA',0
                dd      HKEY_CURRENT_CONFIG
                db      'HKEY_CURRENT_CONFIG',0
                dd      HKEY_DYN_DATA 
                db      'HKEY_DYN_DATA',0
                
szKey           db      16383 dup(0)
szVal           db      1024 dup(0)
sizeVal         dd      sizeof szVal
lpVal           dd      ?
lpType          dd      REG_SZ
lpData          db      8096 dup(0)
Vals            dd      ?
cbData          dd      sizeof lpData
DefaultItem     db      '(DEFAULT)',0
ValueNotSet     db      '(Value not set)',0
BinStringBuffer db      256 dup(0)

RegValueTypes       dd      REG_BINARY
                    db      'REG_BINARY',0
                    dd      REG_DWORD
                    db      'REG_DWORD',0
                    dd      REG_DWORD_LITTLE_ENDIAN
                    db      'REG_DWORD_LITTLE_ENDIAN',0
                    dd      REG_DWORD_BIG_ENDIAN
                    db      'REG_DWORD_BIG_ENDIAN',0
                    dd      REG_EXPAND_SZ
                    db      'REG_EXPAMD_SZ',0
                    dd      REG_LINK
                    db      'REG_LINK',0
                    dd      REG_MULTI_SZ
                    db      'REG_MULTI_SZ',0
                    dd      REG_NONE
                    db      'REG_NONE',0
                    dd      REG_QWORD
                    db      'REG_QWORD',0
                    dd      REG_QWORD_LITTLE_ENDIAN
                    db      'REG_QWORD_LITTLE_ENDIAN',0
                    dd      REG_SZ
                    db      'REG_SZ',0
                    
    
; ++++ Other vars and structs ++++

rect        RECT        <>
tvTextBuffer    db  256 dup(0)
lpszValIcon     db      '.\val.ico',0
hIcon           dd      ?
hList           dd      ?
hMem            dd      ?
TempBuffer      db      1024 dup(0)
EmptyString     db      256 dup(20h),0
NullString      db      0
hFont           dd      ?
dwNumBuffer       db      8 dup('0'),'H',0
xlat_table      db      '0123456789abcdef',0
.code
    start:
        invoke  GetModuleHandle,NULL
        mov hInstance,eax
        invoke  WinMain,hInstance,NULL,NULL,SW_SHOWNORMAL
        invoke  ExitProcess,eax

WinMain PROC    hInst:DWORD,hPInst:DWORD,CmdLine:DWORD,CmdShow:DWORD

    local   msg:MSG

    push    hInstance
    pop     wc.hInstance
    invoke  LoadIcon,NULL,IDI_APPLICATION
    mov     wc.hIcon,eax
    mov     wc.hIconSm,eax
    invoke  LoadCursor,NULL,IDC_ARROW
    mov     wc.hCursor,eax
    invoke  RegisterClassEx,addr wc
    invoke  GetSystemMetrics,SM_CYSCREEN
    shr     eax,1
    sub     eax,MainWindowHeight/2
    push    eax
    invoke  GetSystemMetrics,SM_CXSCREEN
    shr     eax,1
    sub     eax,MainWindowWidth/2
    pop     ebx
    invoke  CreateWindowEx,NULL,addr MainWindowClass,addr MainWindowName,WS_TILEDWINDOW,\   
               eax,ebx,MainWindowWidth,MainWindowHeight,NULL,NULL,hInstance,NULL
    mov     hMainWindow,eax
    invoke  ShowWindow,eax,CmdShow
    invoke  UpdateWindow,hMainWindow
msg_loop:
    invoke  GetMessage,addr msg,NULL,0,0
    or      eax,eax
    jz      end_msg_loop
    invoke  TranslateMessage,addr msg
    invoke  DispatchMessage,addr msg
    jmp     msg_loop
end_msg_loop:
    mov     eax,msg.wParam
    ret

WinMain     endp

WndProc PROC    hWnd:DWORD,uMsg:DWORD,wParam:DWORD,lParam:DWORD

    .if uMsg==WM_DESTROY
        invoke  PostQuitMessage,NULL
    .elseif uMsg==WM_CREATE
        mov edi,lParam
        .if [edi.CREATESTRUCT].hwndParent==NULL
            invoke  InitCommonControls
            invoke  GetClientRect,hWnd,addr rect
            push    rect.right
            shr     rect.right,2
            sub     rect.bottom,22
            invoke  CreateWindowEx,WS_EX_STATICEDGE,addr TreeViewClass,NULL,WS_VISIBLE+WS_CHILD+\
                        TVS_HASLINES+TVS_LINESATROOT+TVS_HASBUTTONS,0,0,rect.right,rect.bottom,\
                        hWnd,TreeViewID,hInstance,NULL
            mov hTreeView,eax
;            invoke  SendMessage,hTreeView,CCM_SETUNICODEFORMAT,TRUE,NULL
            invoke  SendMessage,hTreeView,WM_GETFONT,NULL,NULL
            mov     hFont,eax
            mov     eax,rect.right
            add     eax,2
            pop     rect.right
            push    rect.right
            sub     rect.right,eax
            push    rect.right
            invoke  CreateWindowEx,WS_EX_STATICEDGE,addr ListViewClass,NULL,WS_VISIBLE+WS_CHILD+\
                        LVS_REPORT,eax,0,rect.right,rect.bottom,\
                        hWnd,ListViewID,hInstance,NULL
            mov     hListView,eax
            invoke  LoadImage,hInstance,addr lpszValIcon,IMAGE_ICON,20,20,LR_LOADFROMFILE
            mov     hIcon,eax
            invoke  ImageList_Create,20,20,ILC_COLOR,1,1
            mov     hList,eax
            invoke  ImageList_AddIcon,hList,hIcon
            invoke  DestroyIcon,hIcon
            invoke  SendMessage,hListView,LVM_SETIMAGELIST,LVSIL_SMALL,hList
            pop     rect.right
            mov     lvc.imask,LVCF_TEXT+LVCF_WIDTH
            shr     rect.right,1                
            mov     lvc.pszText,offset ColName
            push    rect.right
            pop     lvc.lx
            invoke  SendMessage,hListView,LVM_INSERTCOLUMN,NULL,addr lvc
            mov     lvc.pszText,offset ColType
            shr     rect.right,1
            push    rect.right
            pop     lvc.lx
            invoke  SendMessage,hListView,LVM_INSERTCOLUMN,1,addr lvc
            mov     lvc.pszText,offset ColData
            invoke  SendMessage,hListView,LVM_INSERTCOLUMN,2,addr lvc                   
            pop     rect.right
            mov     eax,rect.bottom
            mov     rect.top,eax
            invoke  CreateWindowEx,WS_EX_STATICEDGE,addr StaticClass,NULL,WS_VISIBLE+WS_CHILD+SS_SIMPLE,\
                        0,rect.top,rect.right,20,hWnd,NULL,hInstance,NULL
            mov     hStatic,eax                        
            invoke  SendMessage,hStatic,WM_SETFONT,hFont,TRUE
            call    FillTVControl
        .endif                                    

    .elseif uMsg==WM_NOTIFY
        mov     edi,lParam
        assume  edi:PTR NM_TREEVIEW
        .if  [edi].hdr.code==TVN_ITEMEXPANDING
            invoke  SendMessage,hTreeView,TVM_GETNEXTITEM,TVGN_CHILD,[edi].itemNew.hItem
            mov     tvi.hItem,eax
            mov     tvi.imask,TVIF_CHILDREN+TVIF_HANDLE
            invoke  SendMessage,hTreeView,TVM_GETITEM,NULL,addr tvi
            .if     tvi.cChildren!=1
                 invoke  FillSubLevel,addr [edi].itemNew
            .endif                
        .elseif [edi].hdr.code==TVN_SELCHANGED
            invoke  SendMessage,hListView,LVM_DELETEALLITEMS,NULL,NULL
            invoke  FillListViewControl,addr [edi].itemNew            
        .endif                  
    .elseif uMsg==WM_SIZE
                            
    .else
        invoke  DefWindowProc,hWnd,uMsg,wParam,lParam
        ret
    .endif
    xor eax,eax
    ret

WndProc     endp

FillTVControl   PROC

    local   hCurrentKey:DWORD,hNewKey:DWORD
    local   nIndex:DWORD
    local   hRootItem:DWORD
    


    mov     tvis.item.imask,TVIF_TEXT+TVIF_PARAM+TVIF_CHILDREN
    mov     nIndex,0
    mov     ecx,NoSystemKeys
    lea     esi,SystemKeys
    cld
@@1:
    mov     tvis.hInsertAfter,TVI_ROOT
    mov     tvis.hParent,0
    lodsd
    mov     hCurrentKey,eax
    mov     tvis.item.lParam,eax    
    push    ecx
    invoke  RegEnumKey,hCurrentKey,0,addr szKey,sizeof szKey
    cmp     eax,ERROR_SUCCESS
    jne     no_more_keys
    mov     tvis.item.cChildren,1
    mov     tvis.item.pszText,esi
    invoke  SendMessage,hTreeView,TVM_INSERTITEM,NULL,addr tvis
    mov     tvis.hParent,eax
    mov     tvis.item.pszText,offset szKey
    mov     tvis.hInsertAfter,TVI_LAST
    mov     tvis.item.cChildren,0
@@2:
    invoke  RegEnumKey,hCurrentKey,nIndex,addr szKey,sizeof szKey
    cmp     eax,ERROR_SUCCESS
    jne     no_more_keys
    invoke  SendMessage,hTreeView,TVM_INSERTITEM,NULL,addr tvis
    inc     nIndex
    jmp     @@2
no_more_keys:
    pop     ecx
    dec     ecx
    jcxz    ender
realign_loop:
    lodsb
    cmp     al,0
    jne     realign_loop
    mov     nIndex,0    
    jmp     @@1
ender:
    ret                            

FillTVControl   endp


FillSubLevel    PROC    lptvi:LPSTR
    
    local   hCurrentKey:DWORD,hTempKey:DWORD
    local   cnt:DWORD
    local   nIndex:DWORD
    local   TVGN_FLAG:DWORD
    local   FirstUse:DWORD

    mov     FirstUse,TRUE
    mov     TVGN_FLAG,TVGN_CHILD
    mov     edi,lptvi
    assume  edi:PTR TV_ITEM
    mov     eax,[edi].hItem
    mov     tvi.imask,TVIF_HANDLE+TVIF_PARAM+TVIF_TEXT+TVIF_CHILDREN
    mov     tvi.pszText,offset tvBuffer
    mov     tvi.cchTextMax,sizeof tvBuffer
    mov     tvis.item.imask,TVIF_TEXT;+TVIF_PARAM
    mov     tvis.item.pszText,offset szKey
    mov     tvis.item.cchTextMax,sizeof szKey
    mov     tvis.hInsertAfter,TVI_FIRST
    mov     cnt,1
@@1:
    push    eax
    invoke  SendMessage,hTreeView,TVM_GETNEXTITEM,TVGN_PARENT,eax
    cmp     eax,NULL
    je      end_@@1
    inc     cnt
    jmp     @@1
end_@@1:
    pop     tvi.hItem
    invoke  SendMessage,hTreeView,TVM_GETITEM,NULL,addr tvi
    push    tvi.lParam
    pop     hCurrentKey
; +++ recent changes
    lea     esi,SystemKeys    
    cld
loop_0:    
    lodsd
    cmp     eax,tvi.lParam
    je      found_sys_key
realign_loop:
    lodsb
    cmp     al,0
    jne     realign_loop
    jmp     loop_0
found_sys_key:
   ; invoke  CopyStringAddBar,addr TempBuffer,esi    
; +++ end of recent changes        
    dec     cnt
    cmp     cnt,0
    je      end_fsl
    
    pop     tvi.hItem
    invoke  SendMessage,hTreeView,TVM_GETITEM,NULL,addr tvi
    invoke  CopyStringAddBar,addr TempBuffer,tvi.pszText    
    dec     cnt
    cmp     cnt,0
    je      end_fsl    
@@2:
    pop     tvi.hItem
    invoke  SendMessage,hTreeView,TVM_GETITEM,NULL,addr tvi
    invoke  AddString,addr TempBuffer,tvi.pszText    
 ;     invoke  RegOpenKey,hCurrentKey,tvi.pszText,addr hTempKey
 ;     push    hTempKey
 ;     pop     hCurrentKey
    dec     cnt
    cmp     cnt,0
    jne     @@2
end_fsl:
    invoke  RegOpenKeyEx,hCurrentKey,addr TempBuffer,NULL,KEY_ENUMERATE_SUB_KEYS,addr hTempKey
    push    hTempKey
    pop     hCurrentKey
@@3:    
    push    hCurrentKey
    push    tvi.hItem    
    pop     tvis.hParent
    invoke  SendMessage,hTreeView,TVM_GETNEXTITEM,TVGN_FLAG,tvi.hItem
    cmp     eax,NULL
    je      end_fsl_2
    mov     tvi.hItem,eax
    mov     tvis.hParent,eax
    invoke  SendMessage,hTreeView,TVM_GETITEM,NULL,addr tvi
    invoke  RegOpenKeyEx,hCurrentKey,tvi.pszText,NULL,KEY_ENUMERATE_SUB_KEYS,addr hTempKey
    push    hTempKey
    pop     hCurrentKey
    mov     nIndex,0
looper:
    invoke  RegEnumKey,hCurrentKey,nIndex,addr szKey,256
    cmp     eax,ERROR_SUCCESS
    je      success
    invoke  RegCloseKey,hCurrentKey
    pop     hCurrentKey
    mov     nIndex,0
    mov     TVGN_FLAG,TVGN_NEXT
    mov     FirstUse,TRUE
    jmp     @@3
success:    
    .if     FirstUse==TRUE      ; Just execute once for each child item and only if it has child items to force childbox
            mov     tvi.cChildren,1
            invoke  SendMessage,hTreeView,TVM_SETITEM,NULL,addr tvi
            mov     FirstUse,FALSE
    .endif    
    invoke  SendMessage,hTreeView,TVM_INSERTITEM,NULL,addr tvis    
    inc     nIndex
    jmp     looper
end_fsl_2:
    pop     eax
    invoke  RegCloseKey,eax
    .if     eax!=ERROR_SUCCESS
        invoke  MessageBox,NULL,NULL,NULL,MB_OK
    .endif                
    ret
FillSubLevel    endp

FillListViewControl PROC    uses    edi esi lptvi:LPSTR
    
    local   hCurrentKey:DWORD,hTempKey:DWORD
    local   nIndex:DWORD,cnt:DWORD
    local   KeyCounter:DWORD
    local   cbValueName:DWORD,lpValueName:DWORD
    local   cbValueData:DWORD,lpValueData:DWORD
    local   hMemValue:DWORD,hMemData:DWORD
    
    mov     edi,lptvi
    assume  edi:PTR TV_ITEM
    mov     tvi.imask,TVIF_TEXT+TVIF_PARAM+TVIF_HANDLE
    mov     tvi.pszText,offset tvBuffer
    mov     lvi.imask,LVIF_TEXT
    mov     lvi.iItem,0
    mov     cnt,1
    mov     eax,[edi].hItem
    mov     KeyCounter,0
loop_0:
    push    eax
    invoke  SendMessage,hTreeView,TVM_GETNEXTITEM,TVGN_PARENT,eax    
    cmp     eax,NULL
    je      end_loop_0
    inc     cnt
    jmp     loop_0
end_loop_0:
    pop     tvi.hItem
    invoke  SendMessage,hTreeView,TVM_GETITEM,NULL,addr tvi
    push    tvi.lParam
    pop     hCurrentKey
; +++ recent changes +++

    lea     esi,SystemKeys
    cld
loop_x:
    lodsd
    cmp     eax,tvi.lParam
    je      found_sys_key
realign_loop:
    lodsb
    cmp     al,0
    jne     realign_loop
    jmp     loop_x
found_sys_key:
;    invoke  CopyStringAddBar,addr TempBuffer,tvi.pszText 
;+++ end of recent changes +++
    
    dec     cnt
    cmp     cnt,0
    je      do
    pop     tvi.hItem
    invoke  SendMessage,hTreeView,TVM_GETITEM,NULL,addr tvi
    invoke  CopyStringAddBar,addr TempBuffer,tvi.pszText
    dec     cnt
    cmp     cnt,0
    je      do
    
loop_1:
    pop     tvi.hItem
    invoke  SendMessage,hTreeView,TVM_GETITEM,NULL,addr tvi
    invoke  AddString,addr TempBuffer,tvi.pszText
    dec     cnt
    cmp     cnt,0
    je      do
    jmp     loop_1
do:
    invoke  RegOpenKeyEx,hCurrentKey,addr TempBuffer,NULL,STANDARD_RIGHTS_REQUIRED+KEY_QUERY_VALUE,addr hTempKey
    push    hTempKey
    pop     hCurrentKey
    mov     nIndex,0
    push    hCurrentKey
    mov  cbValueName,16383
    mov  cbValueData,16383
    invoke  GlobalAlloc,GMEM_ZEROINIT,cbValueName
    mov     lpValueName,eax
    invoke  GlobalAlloc,GMEM_ZEROINIT,cbValueData
    mov     lpValueData,eax
loop_2: 
    cmp     nIndex,0
    jne     sk_0
    invoke  RegQueryValueEx,hCurrentKey,NULL,NULL,NULL,lpValueData,addr cbValueData
    test    eax,eax
    jz      has_data        
    jmp     no_data
sk_0:        
    invoke  RegEnumValue,hCurrentKey,nIndex,lpValueName,addr cbValueName,0,addr lpType,lpValueData,addr cbValueData
test_it:    
    cmp     eax,ERROR_SUCCESS
    je      skip_1
    cmp     eax,ERROR_MORE_DATA
    jne     skip_1
    invoke  GlobalFree,lpValueData
    invoke  GlobalFree,lpValueName
    inc     cbValueName
    inc     cbValueData
    invoke  GlobalAlloc,GMEM_ZEROINIT,cbValueData
    mov     lpValueData,eax
    invoke  GlobalAlloc,GMEM_ZEROINIT,cbValueName
    mov     lpValueName,eax
    jmp     loop_2
skip_1:    
    test    eax,eax
    jnz     end_it
    jmp     no_default
no_data:    
    invoke  MyInsertItem,addr DefaultItem,sizeof DefaultItem,lpType,addr ValueNotSet,sizeof ValueNotSet
    jmp     skip_3
has_data:    
    invoke  MyInsertItem,addr DefaultItem,sizeof DefaultItem,lpType, lpValueData,cbValueData 
    jmp     skip_2       
no_default:    
    invoke  MyInsertItem,lpValueName,cbValueName,lpType, lpValueData,cbValueData
skip_2:    
    inc     nIndex
skip_3:    
    inc     lvi.iItem
    jmp     sk_0
end_it:
    pop     eax
    invoke  RegCloseKey,eax
    invoke  SendMessage,hStatic,WM_SETTEXT,NULL,addr EmptyString
    invoke  SendMessage,hStatic,WM_SETTEXT,NULL,addr TempBuffer
    invoke  GlobalFree,lpValueData
    invoke  GlobalFree,lpValueName
    mov     lpType,REG_SZ
    ret
        
FillListViewControl endp                        

CopyStringAddBar    PROC    lpBuffer:LPSTR,lpString:DWORD

    mov     esi,lpString
    mov     edi,lpBuffer
    cld
loop_0:
    lodsb   
    cmp     al,0
    je      end_loop_0
    stosb
    jmp     loop_0
end_loop_0:    
    mov     al,0
    stosb
    ret

CopyStringAddBar    endp

AddString   PROC    lpBuffer:LPSTR,lpString:DWORD

    mov     esi,lpBuffer
    cld
loop_0:    
    lodsb   
    cmp     al,0
    jne     loop_0
    dec     esi
    mov     edi,esi
    mov     al,'\'
    stosb
    mov     esi,lpString    
loop_1:
    lodsb
    cmp     al,0
    je      end_loop_1
    stosb
    jmp     loop_1
end_loop_1:
    mov     al,0
    stosb
    ret

AddString   endp        

MyInsertItem  PROC    lptValueName:DWORD,cobValueName:DWORD,lptType:DWORD,lptValueData:DWORD,cobValueData:DWORD

    pushfd
    mov     lvi.imask,LVIF_TEXT+LVIF_IMAGE
    mov     lvi.iSubItem,0
    push    lptValueName
    pop     lvi.pszText
    invoke  SendMessage,hListView,LVM_INSERTITEM,NULL,addr lvi
    mov     ebx,lpType
    lea     esi,RegValueTypes
    mov     ecx,NoValueTypes
    cld
loop_0:
    lodsd
    cmp    eax,ebx
    je     found_type
    dec     ecx
    cmp     ecx,0
    je      end_it
realign_loop:
    lodsb
    cmp     al,0
    jne     realign_loop
    jmp     loop_0
found_type:
        mov     lvi.imask,LVIF_TEXT
        inc     lvi.iSubItem
        mov     lvi.pszText,esi
        invoke  SendMessage,hListView,LVM_SETITEM,NULL,addr lvi
        mov     edi,offset TempBuffer
        mov     esi,lptValueData
        inc     lvi.iSubItem
        cld
        cmp     lptType,REG_BINARY
        je      r_bin
        cmp     lptType,REG_DWORD
        je      r_dw
        cmp     lptType,REG_DWORD_LITTLE_ENDIAN
        je      r_dwle
        cmp     lptType,REG_DWORD_BIG_ENDIAN
        je      r_dwbe
        cmp     lptType,REG_EXPAND_SZ
        je      r_exsz
        cmp     lptType,REG_LINK
        je      r_lnk
        cmp     lptType,REG_MULTI_SZ
        je      r_msz
        cmp     lptType,REG_NONE
        je      r_sz
        cmp     lptType,REG_QWORD
        je      r_qw
        cmp     lptType,REG_QWORD_LITTLE_ENDIAN
        je      r_qwle
r_sz:   
        mov     edi,lptValueData
        add     edi,cobValueData
        mov     al,0
        cld
        stosb
        push    lptValueData
        pop     lvi.pszText
        jmp     ins_item        
r_bin:
        mov     esi,lptValueData
        lea     edi,BinStringBuffer
        cld
        mov     ecx,cobValueData
        cmp     ecx,0
        je      end_it
loop_1: 
        push    ecx
        mov     ecx,8
        lodsb
loop_12:
        shl     al,1
        jc      _one
        push    eax
        mov     al,'0'
        stosb
        pop     eax
back_1:        
        dec     ecx
        jcxz    decrement_counter
        clc
        jmp     loop_12
_one:
        push    eax
        mov     al,'1'
        stosb
        pop     eax
        jmp     back_1
decrement_counter:
        pop     ecx
        dec     ecx
        jcxz    rbin_done
        jmp     loop_1
rbin_done: 
        mov     al,'B'
        mov     ah,0
        stosw
        push    offset BinStringBuffer
        pop     lvi.pszText
        jmp     ins_item
r_dw:
        mov     ebx,10h
        lea     edi,dwNumBuffer
        mov     eax,'0000'
        cld
        stosd
        stosd
        dec     edi
        std
        mov     eax,lptValueData
        mov     eax,dword ptr [eax]
rdw_loop:    
        xor     edx,edx
        div     ebx
        cmp     eax,0
        je      done_rdw
        push    eax
        push    ebx
        lea     ebx,xlat_table
        mov     al,dl
        xlat    
        stosb
        pop     ebx
        pop     eax
        jmp     rdw_loop
done_rdw:        
        mov     al,dl                           
        lea     ebx,xlat_table
        xlat
        stosb
        push    offset dwNumBuffer
        pop     lvi.pszText
        jmp     ins_item 

r_dwle:
        
r_dwbe:
r_exsz:
r_lnk:
r_msz:
r_lsz:
r_nn:
r_qw:
r_qwle:

        jmp     end_it
                
ins_item:
        invoke  SendMessage,hListView,LVM_SETITEM,NULL,addr lvi
end_it:
        popfd
        ret

MyInsertItem      endp
                    
                                                
end start
