; ++++++++ Dialog Example ++++++++
; +++ Programmed by Luis Costa +++++
; +++++ xandaz@hotmail.com ++++++
; ++++++++ Lisbon, Portugal ++++++++

.586
.model flat,stdcall
option casemap:none

include \masm32\include\windows.inc
include \masm32\include\kernel32.inc
include \masm32\include\user32.inc
include \masm32\include\comctl32.inc

includelib \masm32\lib\kernel32.lib
includelib \masm32\lib\user32.lib
includelib \masm32\lib\comctl32.lib

DialogProc      PROTO   :DWORD,:DWORD,:DWORD,:DWORD

.const
NoButtons      equ       2
.data

hInstance       dd              ?
DlgName         db              'MyDialog',0
hStatus         dd              ?
Command1String  db      'You clicked radio button 1',0
Command2String  db      'You clicked radio button 2',0
Command3String  db      'You clicked radio button 3',0
ToolbarCommand1String   db      'You clicked toolbar Button 1',0
ToolbarCommand2String   db      'You clicked toolbar Button 2',0
hToolbar        dd              ?
TBButtons       TBBUTTON        <0,1,TBSTATE_ENABLED,TBSTYLE_BUTTON,NULL,NULL>
                     TBBUTTON        <1,2,TBSTATE_ENABLED,TBSTYLE_BUTTON,NULL,NULL>
BitmapIDS       dd      100,101,102,103
hList               dd             ?

                     
.code
        start:
                invoke  GetModuleHandle,NULL
                mov     hInstance,eax
                invoke  DialogBoxParam,hInstance,addr DlgName,NULL,addr DialogProc,NULL
                invoke  ExitProcess,eax

DialogProc      PROC    hWnd:DWORD,uMsg:DWORD,wParam:DWORD,lParam:DWORD

        .if     uMsg==WM_INITDIALOG
                invoke  GetDlgItem,hWnd,1007
                mov     hStatus,eax
                invoke  GetDlgItem,hWnd,1003
                mov     hToolbar,eax
                invoke  ImageList_Create,16,16,ILC_COLOR16+ILC_MASK,2,2
                mov     hList,eax
                lea      esi,BitmapIDS
                mov     ecx,2
                cld
iml_loop:
                lodsd
                push    ecx
                invoke  LoadBitmap,hInstance,eax
                push    eax
                lodsd
                invoke  LoadBitmap,hInstance,eax
                pop     ebx
                invoke  ImageList_Add,hList,ebx,eax
                pop     ecx
                dec     ecx
                jcxz    end_iml_loop
                jmp     iml_loop
end_iml_loop:          
                invoke  SendMessage,hToolbar,TB_SETIMAGELIST,NULL,hList      
                invoke  SendMessage,hToolbar,TB_BUTTONSTRUCTSIZE,sizeof TBBUTTON,NULL
                invoke  SendMessage,hToolbar,TB_ADDBUTTONS,NoButtons,addr TBButtons
                
        .elseif uMsg==WM_CLOSE
                invoke  EndDialog,hWnd,NULL                
        .elseif uMsg==WM_COMMAND
                mov     eax,wParam
                ror     eax,16
                .if     ax==BN_CLICKED
                        rol     eax,16
                        .if     ax==1004
                                invoke  SendMessage,hStatus,WM_SETTEXT,NULL,addr Command1String
                        .elseif ax==1005
                                invoke  SendMessage,hStatus,WM_SETTEXT,NULL,addr Command2String
                        .elseif ax==1006                                                           
                                invoke  SendMessage,hStatus,WM_SETTEXT,NULL,addr Command3String
                        .elseif ax==1
                                invoke  SendMessage,hStatus,WM_SETTEXT,NULL,addr ToolbarCommand1String
                        .elseif ax==2                                
                                invoke  SendMessage,hStatus,WM_SETTEXT,NULL,addr ToolbarCommand2String
                        .endif  
                .endif                                                      
        .else
                mov     eax,FALSE
                ret
        .endif
ret_true:        
        mov     eax,TRUE
        ret

DialogProc      endp

end     start
