; +++++ Toolbar Example +++++
; + email:lajpsc@gmail..com +

.586
.model flat,stdcall
option casemap:none

WinMain PROTO   :DWORD,:DWORD,:DWORD,:DWORD
CreateTab1      PROTO   :DWORD
CreateTab2      PROTO   :DWORD
ConvertToASCII  PROTO   :DWORD,:DWORD

include c:\masm32\include\windows.inc
include c:\masm32\include\kernel32.inc
include c:\masm32\include\user32.inc
include c:\masm32\include\comctl32.inc
include c:\masm32\include\gdi32.inc

includelib c:\masm32\lib\kernel32.lib
includelib c:\masm32\lib\user32.lib
includelib c:\masm32\lib\comctl32.lib
includelib c:\masm32\lib\gdi32.lib

.const

MainWindowWidth         equ     240
MainWindowHeight        equ     300
Left            equ             70
Top            equ             150

.data

hInstance       DWORD           ?
CommandLine     LPSTR           ?

hMainWindow     dd              ?
MainWindowClass db              'MainWindowClass',0
MainWindowName  db              'Tab Control Example',0

; ++++ Tab Control Related ++++

TabClass        db      'SysTabControl32',0
hTab            dd              ?
tci             TC_ITEM         <>
Tab1String      db      'TAB 1',0
Tab2String      db      'TAB 2',0
CurTab          dd      	0

; ++++ Static related ++++

hFont           dd              ?
StaticClass     db      'STATIC',0
hStatic         dd              ?
hStatic1        dd              ?
hStatic2        dd              ?
hStatic3        dd              ?
hStatic4        dd              ?
; ++++ Button related

ButtonClass     db      'BUTTON',0
hFrame          dd              ?
hButton1        dd              ?
hButton2        dd              ?
hButton3        dd              ?
hFrame2         dd              ?
GroupBox        db              'Choose Setting',0
szButton1   db      'Setting 1',0
szButton2   db      'Setting 2',0
szButton3   db      'Setting 3',0
szButton1Status         db              'Youve chosen Setting 1',0
szButton2Status         db              'Youve chosen Setting 2',0
szButton3Status         db              'Youve chosen Setting 3',0

; ++++ Trackbar related ++++

TrackbarClass   db      'msctls_trackbar32',0
hTrack1         dd              ?
hTrack2         dd              ?
hTrack3         dd              ?
Range           dd              0FF0000h

; ++++ Other Vars +++++

rect            RECT            <>
xlat_table      db      '0123456789ABCDEF',0
CurState1        dd              TRUE
CurState2       dd              FALSE
CurState3       dd              FALSE
Color           COLORREF        ?
hDC             HDC                 ?
hBrush         HBRUSH	      ?
TabRect         RECT            <Left,Top,Left+80,Top+80>
szColorTest     db      'Color Test',0


.code
        start:
                invoke  GetModuleHandle,NULL
                mov     hInstance,eax
                invoke  GetCommandLine
                mov     CommandLine,eax
                invoke  InitCommonControls
                invoke  WinMain,hInstance,NULL,CommandLine,SW_SHOWDEFAULT
                invoke  ExitProcess,eax

WinMain PROC    hInst:DWORD,hPrevInst:DWORD,CmdLine:DWORD,CmdShow:DWORD

        local   wc:WNDCLASSEX
        local   msg:MSG

        mov     wc.cbSize,sizeof wc
        mov     wc.style,CS_HREDRAW+CS_VREDRAW
        mov     wc.lpfnWndProc,offset WndProc
        mov     wc.lpszMenuName,NULL
        mov     wc.lpszClassName,offset MainWindowClass
        mov     wc.cbClsExtra,NULL
        mov     wc.cbWndExtra,NULL
        mov     wc.hbrBackground,COLOR_WINDOW
        push    hInst
        pop     wc.hInstance
        invoke  LoadIcon,NULL,IDI_APPLICATION
        mov     wc.hIcon,eax
        mov     wc.hIconSm,eax
        invoke  LoadCursor,NULL,IDC_ARROW
        mov     wc.hCursor,eax
        invoke  RegisterClassEx,addr wc
        invoke  GetSystemMetrics,SM_CYSCREEN
        shr     eax,1
        sub     eax,MainWindowHeight/2
        push    eax
        invoke  GetSystemMetrics,SM_CXSCREEN
        shr     eax,1
        sub     eax,MainWindowWidth/2
        pop     ebx
        invoke  CreateWindowEx,NULL,addr MainWindowClass,addr MainWindowName,WS_TILEDWINDOW,\
                eax,ebx,MainWindowWidth,MainWindowHeight,NULL,NULL,hInstance,NULL
        mov     hMainWindow,eax
        invoke  ShowWindow,eax,SW_SHOWNORMAL
        invoke  UpdateWindow,hMainWindow

        .while  TRUE

                invoke  GetMessage,addr msg,NULL,0,0

        .break .if (!eax)

                invoke  TranslateMessage,addr msg
                invoke  DispatchMessage,addr msg

        .endw

        mov     eax,msg.wParam
        ret

WinMain endp

WndProc PROC    hWnd:DWORD,uMsg:DWORD,wParam:DWORD,lParam:DWORD

        local   itemRect:RECT
        
        .if     uMsg==WM_DESTROY

                invoke  PostQuitMessage,NULL

        .elseif uMsg==WM_CREATE
                .if     [lParam.CREATESTRUCT].hWndParent==NULL
                        invoke  CreateTab1,hWnd
                        invoke  CreateTab2,hWnd
                        invoke  GetClientRect,hWnd,addr rect
                        invoke  CreateWindowEx,NULL,addr TabClass,NULL,WS_VISIBLE+WS_CHILD+TCS_FIXEDWIDTH,\ ;+TCS_TABS,\
                                        0,0,rect.right,rect.bottom,hWnd,0200h,hInstance,NULL
                        mov     hTab,eax                                        
                        mov     tci.imask,TCIF_TEXT
                        mov     tci.pszText,offset Tab1String
                        mov     tci.cchTextMax,sizeof Tab1String
                        mov     tci.iImage,-1
                        mov     tci.lParam,0
                        invoke  SendMessage,hTab,TCM_INSERTITEM,0,addr tci
                        mov     tci.pszText,offset Tab2String
                        mov     tci.cchTextMax,sizeof Tab2String
                        invoke  SendMessage,hTab,TCM_INSERTITEM,1,addr tci
                        invoke  GetClientRect,hTab,addr rect
                        invoke  SendMessage,hTab,TCM_GETITEMRECT,1,addr itemRect
                        invoke  SendMessage,hButton1,BM_SETCHECK,BST_CHECKED,NULL
                        invoke  SendMessage,hStatic1,WM_SETTEXT,NULL,addr szButton1Status     
                   
                .endif     
        .elseif uMsg==WM_NOTIFY


                mov     eax,lParam
                mov     eax,(NMHDR PTR [eax]).code
                .if     eax==TCN_SELCHANGE
                        invoke  SendMessage,hTab,TCM_GETCURSEL,NULL,NULL
                        .if     eax!=CurTab
                                .if     eax==0
                                call   ShowTab1
                                invoke  InvalidateRect,hWnd,addr TabRect,TRUE
                                mov     CurTab,0
                                .elseif eax==1
                                call    ShowTab2
                                invoke  ValidateRect,hWnd,addr TabRect
                                mov     CurTab,1
                                .endif
                        .endif                   
                .endif
        .elseif uMsg==WM_COMMAND
                mov     eax,wParam
                                                
                .if     ax==100
                        .if     CurState1==FALSE
                                invoke  SendMessage,hButton1,BM_SETCHECK,BST_CHECKED,NULL
                                invoke  SendMessage,hButton2,BM_SETCHECK,BST_UNCHECKED,NULL
                                invoke  SendMessage,hButton3,BM_SETCHECK,BST_UNCHECKED,NULL
                                invoke  SendMessage,hStatic1,WM_SETTEXT,NULL,addr szButton1Status                                
                                mov     CurState1,TRUE
                                mov     CurState2,FALSE
                                mov     CurState3,FALSE
                        .endif
                .elseif ax==101
                        .if     CurState2==FALSE
                                invoke  SendMessage,hButton1,BM_SETCHECK,BST_UNCHECKED,NULL
                                invoke  SendMessage,hButton2,BM_SETCHECK,BST_CHECKED,NULL
                                invoke  SendMessage,hButton3,BM_SETCHECK,BST_UNCHECKED,NULL
                                invoke  SendMessage,hStatic1,WM_SETTEXT,NULL,addr szButton2Status                                
                                mov     CurState1,FALSE
                                mov     CurState2,TRUE
                                mov     CurState3,FALSE
                        .endif
                .elseif  ax==102
                        .if     CurState3==FALSE
                                invoke  SendMessage,hButton1,BM_SETCHECK,BST_UNCHECKED,NULL
                                invoke  SendMessage,hButton2,BM_SETCHECK,BST_UNCHECKED,NULL
                                invoke  SendMessage,hButton3,BM_SETCHECK,BST_CHECKED,NULL
                                invoke  SendMessage,hStatic1,WM_SETTEXT,NULL,addr szButton3Status
                                mov     CurState1,FALSE
                                mov     CurState2,FALSE
                                mov     CurState3,TRUE
                        .endif                                
                .endif   
        .elseif uMsg==WM_HSCROLL
        
                        invoke  SendMessage,hTrack1,TBM_GETPOS,NULL,NULL
                        mov     ebx,eax
                        invoke  SendMessage,hTrack2,TBM_GETPOS,NULL,NULL
                        shl     eax,8
                        add     ebx,eax
                        invoke  SendMessage,hTrack3,TBM_GETPOS,NULL,NULL
                        shl     eax,16
                        add     ebx,eax
                        invoke  CreateSolidBrush,ebx
                        mov     hBrush,eax
                        invoke  GetDC,hWnd
                        mov     hDC,eax
                        invoke  FillRect,hDC,addr TabRect,hBrush
                        invoke  DeleteObject,hBrush
                        invoke  ReleaseDC,hWnd,hDC

    
        .else

                invoke  DefWindowProc,hWnd,uMsg,wParam,lParam
                ret

        .endif

        xor     eax,eax
        ret

WndProc endp

CreateTab1      PROC    hWnd:DWORD

        invoke  CreateWindowEx,NULL,addr ButtonClass,addr GroupBox,WS_VISIBLE+WS_CHILD+BS_GROUPBOX+BS_CENTER,\
                        10,30,200,90,hWnd,NULL,hInstance,NULL
        mov     hFrame,eax                        
        invoke  CreateWindowEx,NULL,addr ButtonClass,addr szButton1,WS_VISIBLE+WS_CHILD+BS_RADIOBUTTON+WS_TABSTOP,\
                        65,50,120,20,hWnd,100,hInstance,NULL
        mov     hButton1,eax        
        invoke  CreateWindowEx,NULL,addr ButtonClass,addr szButton2,WS_VISIBLE+WS_CHILD+BS_RADIOBUTTON+WS_TABSTOP,\
                        65,70,120,20,hWnd,101,hInstance,NULL
        mov     hButton2,eax 
        invoke  CreateWindowEx,NULL,addr ButtonClass,addr szButton3,WS_VISIBLE+WS_CHILD+BS_RADIOBUTTON+WS_TABSTOP,\
                        65,90,120,20,hWnd,102,hInstance,NULL
        mov     hButton3,eax 
        invoke  CreateWindowEx,WS_EX_STATICEDGE,addr StaticClass,NULL,WS_VISIBLE+WS_CHILD+SS_CENTER,\
                        10,130,200,30,hWnd,NULL,hInstance,NULL
        mov     hStatic1,eax       
        ret

CreateTab1      endp

CreateTab2      PROC    hWnd:DWORD


        invoke  CreateWindowEx,NULL,addr TrackbarClass,NULL,WS_VISIBLE+WS_CHILD+TBS_HORZ+TBS_AUTOTICKS,\
                        20,50,190,20,hWnd,0200h,hInstance,NULL
        mov     hTrack1,eax
        invoke  ShowWindow,hTrack1,SW_HIDE
        invoke  SendMessage,hTrack1,TBM_SETRANGE,TRUE,Range        
        invoke  SendMessage,hTrack1,TBM_SETTICFREQ,16,0
        invoke  CreateWindowEx,NULL,addr TrackbarClass,addr szButton1,WS_VISIBLE+WS_CHILD+TBS_HORZ+TBS_AUTOTICKS,\
                        20,80,190,20,hWnd,0200h,hInstance,NULL
        mov     hTrack2,eax
        invoke  SendMessage,hTrack2,TBM_SETRANGE,TRUE,Range        
        invoke  SendMessage,hTrack2,TBM_SETTICFREQ,16,0        
        invoke  ShowWindow,hTrack2,SW_HIDE
        invoke  CreateWindowEx,NULL,addr TrackbarClass,NULL,WS_VISIBLE+WS_CHILD+TBS_HORZ+TBS_AUTOTICKS,\
                        20,110  ,190,20,hWnd,0200h,hInstance,NULL
        mov     hTrack3,eax    
        invoke  ShowWindow,hTrack3,SW_HIDE
        invoke  SendMessage,hTrack3,TBM_SETRANGE,TRUE,Range        
        invoke  SendMessage,hTrack3,TBM_SETTICFREQ,16,0
        invoke  CreateWindowEx,NULL,addr ButtonClass,addr szColorTest,WS_VISIBLE+WS_CHILD+BS_GROUPBOX+BS_CENTER,\
                        5,30,212,228,hWnd,NULL,hInstance,NULL
        mov     hFrame2,eax                        
        invoke  ShowWindow,hFrame2,SW_HIDE
        ret

CreateTab2      endp
                                                    
ShowTab1        PROC

        invoke  ShowWindow,hTrack1,SW_HIDE
        invoke  ShowWindow,hTrack2,SW_HIDE        
        invoke  ShowWindow,hTrack3,SW_HIDE  
        invoke  ShowWindow,hFrame2,SW_HIDE      
        invoke  ShowWindow,hFrame,SW_SHOW
        invoke  ShowWindow,hButton1,SW_SHOW
        invoke  ShowWindow,hButton2,SW_SHOW
        invoke  ShowWindow,hButton3,SW_SHOW
        invoke  ShowWindow,hStatic1,SW_SHOW                
        ret
        
ShowTab1        endp

ShowTab2        PROC

        invoke  ShowWindow,hFrame,SW_HIDE
        invoke  ShowWindow,hButton1,SW_HIDE
        invoke  ShowWindow,hButton2,SW_HIDE
        invoke  ShowWindow,hButton3,SW_HIDE
        invoke  ShowWindow,hStatic1,SW_HIDE
        invoke  ShowWindow,hTrack1,SW_SHOW
        invoke  ShowWindow,hTrack2,SW_SHOW
        invoke  ShowWindow,hTrack3,SW_SHOW
        invoke  ShowWindow,hStatic4,SW_SHOW
        invoke  ShowWindow,hFrame2,SW_SHOW
        ret        
       
ShowTab2        endp        

end     start                                       