; +++++ ChooseColor Dialog Example +++++
; ++++++ Programmed by Luis Costa ++++++
; ++++++++++ Lisbon, Portugal ++++++++++
; +++++++++ xandaz@hotmail.com +++++++++


.586    
.model flat,stdcall
option casemap:none

WinMain PROTO   :DWORD,:DWORD,:DWORD,:DWORD

include \masm32\include\windows.inc
include \masm32\include\kernel32.inc
include \masm32\include\user32.inc
include \masm32\include\comdlg32.inc
include \masm32\include\comctl32.inc
include \masm32\include\gdi32.inc

includelib \masm32\lib\kernel32.lib
includelib \masm32\lib\user32.lib
includelib \masm32\lib\comdlg32.lib
includelib \masm32\lib\comctl32.lib
includelib \masm32\lib\gdi32.lib

.const

MainWindowWidth     equ     600
MainWindowHeight    equ     350

.data

hInstance       dd      ?
hMainWindow     dd      ?
MainWindowClass db      'MainWindowClass',0
MainWindowName  db      '???',0

wc          WNDCLASSEX  <sizeof wc,CS_HREDRAW+CS_VREDRAW,offset WndProc,NULL,NULL,NULL, \
                        NULL,NULL,COLOR_WINDOW,NULL,offset MainWindowClass,NULL>
cf          CHOOSEFONT  <sizeof cf,?,?,offset lf,?,CF_APPLY+CF_SCREENFONTS,NULL,NULL,NULL,offset cfName,?,\
                        SCREEN_FONTTYPE,6,20>
lf          LOGFONT     <>                        
cfName  db  'ChooseFont',0                        
ButtonClass db  'BUTTON',0
hButton     dd      ?
RichEdLib   db      'riched32.dll',0
RichEditClass   db      'RichEdit20A',0
hRichEd     dd      ?
hRichEdLib  dd      ?
rect        RECT        <>
szFnt       db      '.\fnt.ico',0
                                               
.code
    start:
        invoke  GetModuleHandle,NULL
        mov hInstance,eax
        invoke  WinMain,hInstance,NULL,NULL,SW_SHOWNORMAL
        invoke  ExitProcess,eax

WinMain PROC    hInst:DWORD,hPInst:DWORD,CmdLine:DWORD,CmdShow:DWORD

    local   msg:MSG

    push    hInstance
    pop     wc.hInstance
    invoke  LoadIcon,NULL,IDI_APPLICATION
    mov     wc.hIcon,eax
    mov     wc.hIconSm,eax
    invoke  LoadCursor,NULL,IDC_ARROW
    mov     wc.hCursor,eax
    invoke  RegisterClassEx,addr wc
    invoke  GetSystemMetrics,SM_CYSCREEN
    shr     eax,1
    sub     eax,MainWindowHeight/2
    push    eax
    invoke  GetSystemMetrics,SM_CXSCREEN
    shr     eax,1
    sub     eax,MainWindowWidth/2
    pop     ebx
    invoke  CreateWindowEx,NULL,addr MainWindowClass,addr MainWindowName,WS_TILEDWINDOW,\   
               eax,ebx,MainWindowWidth,MainWindowHeight,NULL,NULL,hInstance,NULL
    mov     hMainWindow,eax
    invoke  ShowWindow,eax,CmdShow
    invoke  UpdateWindow,hMainWindow

msg_loop:
    invoke  GetMessage,addr msg,NULL,0,0
    or      eax,eax
    jz      end_msg_loop
    invoke  TranslateMessage,addr msg
    invoke  DispatchMessage,addr msg
    jmp     msg_loop
end_msg_loop:
    mov     eax,msg.wParam
    ret

WinMain     endp

WndProc PROC    hWnd:DWORD,uMsg:DWORD,wParam:DWORD,lParam:DWORD

    local   hIcon:DWORD
    
    .if uMsg==WM_DESTROY
        invoke  PostQuitMessage,NULL
    .elseif uMsg==WM_CREATE
        mov edi,lParam
        .if [edi.CREATESTRUCT].hWndParent==NULL
            invoke  InitCommonControls
            invoke  LoadLibrary,addr RichEdLib
            mov     hRichEdLib,eax
            invoke  CreateWindowEx,NULL,addr ButtonClass,NULL,WS_VISIBLE+WS_CHILD+BS_ICON,\
                        0,0,32,32,hWnd,0100h,hInstance,NULL
            mov hButton,eax       
            invoke  LoadImage,hInstance,addr szFnt,IMAGE_ICON,30,30,LR_LOADFROMFILE
            mov     hIcon,eax
skip:            
            invoke  SendMessage,hButton,BM_SETIMAGE,IMAGE_ICON,eax
            invoke  DestroyIcon,hIcon
            invoke  GetClientRect,hWnd,addr rect
            add     rect.top,34
            sub     rect.bottom,34
            invoke  CreateWindowEx,NULL,addr RichEditClass,NULL,WS_VISIBLE+WS_CHILD+ES_MULTILINE+ES_WANTRETURN,\
                        NULL,rect.top,rect.right,rect.bottom,hWnd,NULL,hInstance,NULL
            mov hRichEd,eax                                           
        .endif            
    .elseif uMsg==WM_COMMAND
        mov eax,wParam
        .if ax==100h
            push    hWnd
            pop     cf.hwndOwner  
            push    hInstance
            pop     cf.hInstance  
            invoke  GetDC,hWnd
            push    eax
            pop     cf.hDC
            invoke  ChooseFont,addr cf
            invoke  CreateFontIndirect,addr lf
            invoke  SendMessage,hRichEd,WM_SETFONT,eax,TRUE
        .endif
    .else
        invoke  DefWindowProc,hWnd,uMsg,wParam,lParam
        ret
    .endif
    xor eax,eax
    ret

WndProc     endp

end start                                            
