.586    
.model flat,stdcall
option casemap:none

WinMain PROTO   :DWORD,:DWORD,:DWORD,:DWORD
AddString   PROTO   :DWORD,:DWORD

include \masm32\include\windows.inc
include \masm32\include\kernel32.inc
include \masm32\include\user32.inc
include \masm32\include\comctl32.inc
include \masm32\include\gdi32.inc
include \masm32\include\shell32.inc

includelib \masm32\lib\kernel32.lib
includelib \masm32\lib\user32.lib
includelib \masm32\lib\comctl32.lib
includelib \masm32\lib\gdi32.lib
includelib \masm32\lib\shell32.lib

.const

MainWindowWidth     equ     600
MainWindowHeight    equ     350

LVSTYLE             equ     WS_VISIBLE+WS_CHILD+LVS_OWNERDRAWFIXED+LVS_REPORT+WS_VSCROLL

.data

hInstance       dd      ?
hMainWindow     dd      ?
MainWindowClass db      'MainWindowClass',0
MainWindowName  db      'Owner Draw ListView example',0

wc          WNDCLASSEX  <sizeof wc,CS_HREDRAW+CS_VREDRAW,offset WndProc,NULL,NULL,NULL, \
                        NULL,NULL,COLOR_WINDOW,NULL,offset MainWindowClass,NULL>

; ++++ List View related +++++

hListView       dd      ?
ListViewClass   db      'SysListView32',0
lvi             LV_ITEM	    <>
lvc             LV_COLUMN   <>
Col1            db      'FileName',0
Col2            db      'Attributes',0
pszTextBuffer   db      256 dup(0)

TestItem1       db      'TestFile',0,0
TestItem2       db      'TestDirectory',0,0
TestAttr1       db      '-s-d',0
TestAttr2       db      'as--',0

; ++++ Static related ++++

hStatic         dd      ?
StaticClass     db      'STATIC',0

; ++++ Others +++++

rect            RECT        <>
hMemDC          HDC         ?
hIml            dd          ?
IconFile        db      'c:\config.sys',0
IconDir         db      'c:\Windows',0
hFont           dd          ?
hFontBold       dd          ?
szSpec          db          'c:\*',252 dup(0)
hFind           dd          ?
w32fd       WIN32_FIND_DATA     <>
dwFileAttributes    db      5 dup(0)
EmptyString         db      100 dup(' ')
hMem            dd          ?

.code
    start:
        invoke  GetModuleHandle,NULL
        mov hInstance,eax
        invoke  InitCommonControls
        invoke  WinMain,hInstance,NULL,NULL,SW_SHOWNORMAL
        invoke  ExitProcess,eax

WinMain PROC    hInst:DWORD,hPInst:DWORD,CmdLine:DWORD,CmdShow:DWORD

    local   msg:MSG

    push    hInstance
    pop     wc.hInstance
    invoke  LoadIcon,NULL,IDI_APPLICATION
    mov     wc.hIcon,eax
    mov     wc.hIconSm,eax
    invoke  LoadCursor,NULL,IDC_ARROW
    mov     wc.hCursor,eax
    invoke  RegisterClassEx,addr wc
    invoke  GetSystemMetrics,SM_CYSCREEN
    shr     eax,1
    sub     eax,MainWindowHeight/2
    push    eax
    invoke  GetSystemMetrics,SM_CXSCREEN
    shr     eax,1
    sub     eax,MainWindowWidth/2
    pop     ebx
    invoke  CreateWindowEx,NULL,addr MainWindowClass,addr MainWindowName,WS_TILEDWINDOW,\   
               eax,ebx,MainWindowWidth,MainWindowHeight,NULL,NULL,hInstance,NULL
    mov     hMainWindow,eax
    invoke  ShowWindow,eax,CmdShow
    invoke  UpdateWindow,hMainWindow

msg_loop:
    invoke  GetMessage,addr msg,NULL,0,0
    or      eax,eax
    jz      end_msg_loop
    invoke  TranslateMessage,addr msg
    invoke  DispatchMessage,addr msg
    jmp     msg_loop
end_msg_loop:
    mov     eax,msg.wParam
    ret

WinMain     endp
WndProc PROC    uses edi esi hWnd:DWORD,uMsg:DWORD,wParam:DWORD,lParam:DWORD

    .if uMsg==WM_DESTROY
        invoke  PostQuitMessage,NULL
    .elseif uMsg==WM_CREATE
        mov     edi,lParam
        .if     [edi.CREATESTRUCT].hwndParent==NULL
            invoke  GetClientRect,hWnd,addr rect
            invoke  CreateFont,16,8,NULL,NULL,FW_BOLD,NULL,NULL,NULL,DEFAULT_CHARSET,\
                        OUT_DEFAULT_PRECIS,CLIP_DEFAULT_PRECIS,DEFAULT_QUALITY,\
                        DEFAULT_PITCH+FF_DONTCARE,NULL
            mov     hFontBold,eax                            
            invoke  CreateFont,16,8,NULL,NULL,FW_DONTCARE,NULL,NULL,NULL,DEFAULT_CHARSET,\
                        OUT_DEFAULT_PRECIS,CLIP_DEFAULT_PRECIS,DEFAULT_QUALITY,\
                        DEFAULT_PITCH+FF_DONTCARE,NULL
            mov     hFont,eax   
            push    rect.bottom
            sub     rect.bottom,22
            invoke  CreateWindowEx,NULL,addr ListViewClass,NULL,LVSTYLE,\
                    0,0,rect.right,rect.bottom,hWnd,0100h,hInstance,NULL
            mov     hListView,eax
            mov     eax,rect.bottom
            add     rect.top,eax
            mov     rect.bottom,20
            invoke  CreateWindowEx,WS_EX_STATICEDGE,addr StaticClass,NULL,WS_VISIBLE+WS_CHILD+SS_SIMPLE,\
                        0,rect.top,rect.right,rect.bottom,hWnd,NULL,hInstance,NULL
            mov     hStatic,eax     
            invoke  SendMessage,hStatic,WM_SETFONT,hFont,TRUE                   
            shr     rect.right,1
            push    rect.right
            pop     lvc.lx
            mov     lvc.imask,LVCF_TEXT+LVCF_WIDTH
            mov     lvc.pszText,offset Col1
            invoke  SendMessage,hListView,LVM_INSERTCOLUMN,1,addr lvc
            mov     lvc.pszText,offset Col2
            invoke  SendMessage,hListView,LVM_INSERTCOLUMN,2,addr lvc
            call    FillLV
        .endif
                                    
    .elseif     uMsg==WM_DRAWITEM
        mov     edi,lParam
        assume  edi:PTR DRAWITEMSTRUCT
        .if     [edi].itemAction==ODA_DRAWENTIRE
                invoke  GetStockObject,WHITE_BRUSH
                invoke  FillRect,[edi].hdc,addr [edi].rcItem,eax
                push    [edi].itemID
                pop     lvi.iItem
                mov     lvi.iSubItem,0
                mov     lvi.imask,LVIF_TEXT+LVIF_IMAGE
                mov     lvi.pszText,offset pszTextBuffer
                mov     lvi.cchTextMax,sizeof pszTextBuffer
                invoke  SendMessage,hListView,LVM_GETITEM,NULL,addr lvi
                invoke  ImageList_Draw,hIml,lvi.iImage,[edi].hdc,[edi].rcItem.left,[edi].rcItem.top,ILD_NORMAL
                add     [edi].rcItem.left,22
                add     [edi].rcItem.right,22
                test    [edi].itemState,ODS_SELECTED
                jz      draw_simple
                invoke  SetBkMode,[edi].hdc,OPAQUE
                invoke  SetBkColor,[edi].hdc,8000h
                invoke  SelectObject,[edi].hdc,hFontBold
                jmp     Draw
                
draw_simple:                
                invoke  SelectObject,[edi].hdc,hFont
Draw:              
                invoke  SetTextColor,[edi].hdc,800000h
                invoke  DrawText,[edi].hdc,lvi.pszText,-1,addr [edi].rcItem,DT_LEFT
                mov     lvi.imask,LVIF_TEXT
                inc     lvi.iSubItem
                invoke  SendMessage,hListView,LVM_GETITEM,NULL,addr lvi
                mov     rect.top,1
                mov     rect.left,LVIR_LABEL
                invoke  SendMessage,hListView,LVM_GETSUBITEMRECT,lvi.iItem,addr rect
                invoke  SetBkColor,[edi].hdc,0ffffffh
                invoke  DrawText,[edi].hdc,lvi.pszText,-1,addr rect,DT_LEFT 
                               
                assume  edi:NOTHING
                assume  esi:NOTHING
        .endif 
    .else
        invoke  DefWindowProc,hWnd,uMsg,wParam,lParam
        ret
    .endif
    xor eax,eax
    ret

WndProc     endp

FillLV      PROC

        local       shfi:SHFILEINFO

        invoke  SHGetFileInfo,addr IconFile,NULL,addr shfi,sizeof shfi,SHGFI_SYSICONINDEX+SHGFI_SMALLICON
        mov     hIml,eax
        invoke  SendMessage,hListView,LVM_SETIMAGELIST,LVSIL_SMALL,eax
        mov     lvi.imask,LVIF_TEXT+LVIF_IMAGE
        mov     lvi.iItem,0
        mov     lvi.iSubItem,0
        mov     edi,eax
        assume  edi:PTR LV_ITEM
        invoke  FindFirstFile,addr szSpec,addr w32fd
        or      eax,eax
        jz      end_flv
        mov     hFind,eax
        jmp     compares        
find_next:
        invoke  FindNextFile,hFind,addr w32fd
        or      eax,eax
        jz      end_flv
compares:        
        cmp     w32fd.cFileName,'.'
        je      find_next
do_it:  
                              
        mov     lvi.pszText,offset w32fd.cFileName
        invoke  AddString,addr szSpec,addr w32fd.cFileName
        invoke  SHGetFileInfo,addr szSpec,NULL,addr shfi,sizeof shfi,SHGFI_SYSICONINDEX+SHGFI_SMALLICON
        push    shfi.iIcon
        pop     lvi.iImage
        mov     lvi.cchTextMax,256
        invoke  SendMessage,hListView,LVM_INSERTITEM,NULL,addr lvi
        invoke  SendMessage,hStatic,WM_SETTEXT,NULL,addr EmptyString
        invoke  SendMessage,hStatic,WM_SETTEXT,NULL,addr szSpec  
        lea     edi,dwFileAttributes
        cld
        test    w32fd.dwFileAttributes,FILE_ATTRIBUTE_DIRECTORY
        jz      no_dir
        mov     al,'d'
        stosb
        jmp     @@1
no_dir:
        mov     al,'-'
        stosb
@@1:
        test    w32fd.dwFileAttributes,FILE_ATTRIBUTE_ARCHIVE
        jz      no_archive
        mov     al,'a'
        stosb
        jmp     @@2
no_archive:
        mov     al,'-'
        stosb
@@2:
        test    w32fd.dwFileAttributes,FILE_ATTRIBUTE_HIDDEN
        jz      no_hidden
        mov     al,'h'
        stosb
        jmp     @@3
no_hidden:
        mov     al,'-'
        stosb
@@3:
        test    w32fd.dwFileAttributes,FILE_ATTRIBUTE_SYSTEM
        jz      no_system
        mov     al,'s'
        stosb
        jmp     @@4
no_system:
        mov     al,'-'
        stosb
@@4:
        mov     lvi.pszText,offset dwFileAttributes
        inc     lvi.iSubItem
        mov     lvi.imask,LVIF_TEXT
        invoke  SendMessage,hListView,LVM_SETITEM,NULL,addr lvi
        dec     lvi.iSubItem
        inc     lvi.iItem        
        mov     lvi.imask,LVIF_TEXT+LVIF_IMAGE
        jmp     find_next
end_flv:    
        ret        
    
FillLV      endp

AddString   PROC    lpDest:DWORD,lpSource:DWORD

    mov     esi,lpDest
    cld
align_loop:
    lodsb
    cmp     al,'\'
    jne     align_loop
    mov     edi,esi
    mov     esi,lpSource
looper:
    lodsb
    or      al,al
    jz      end_it
    stosb
    jmp     looper
end_it:
    stosb
    ret

AddString   endp            
end start                                            
