; +++++ Customized Window Example +++++
; +++++++++++ by Luis Costa +++++++++++
; ++++++++++ Lisbon, Portugal +++++++++
; +++++++++ lajpsc@gmail.com ++++++++++


.586    
.model flat,stdcall
option casemap:none

WinMain PROTO   :DWORD,:DWORD,:DWORD,:DWORD

include \masm32\include\windows.inc
include \masm32\include\kernel32.inc
include \masm32\include\user32.inc
include \masm32\include\comctl32.inc
include \masm32\include\gdi32.inc

includelib \masm32\lib\kernel32.lib
includelib \masm32\lib\user32.lib
includelib \masm32\lib\comctl32.lib
includelib \masm32\lib\gdi32.lib

.const

MainWindowWidth     equ     600
MainWindowHeight    equ     350
BS_BTN              equ     WS_CHILD+WS_VISIBLE+BS_BITMAP
ID_MIN              equ     100
ID_MAX              equ     101
ID_CLOSE            equ     102

.data

hInstance       dd      ?
hMainWindow     dd      ?
MainWindowClass db      'MainWindowClass',0
MainWindowName  db      'Customized Window Example 2',0

wc          WNDCLASSEX  <sizeof wc,CS_HREDRAW+CS_VREDRAW,offset WndProc,NULL,NULL,NULL, \
                        NULL,NULL,COLOR_WINDOW,NULL,offset MainWindowClass,NULL>
BarBitmap       db      '.\barbmp.bmp',0
hBitmap         dd          ?
rect            RECT        <>
hDC             HDC         ?
hMemDC          HDC         ? 
StartUp         dd          TRUE
ButtonClass     db          'BUTTON',0
hBtn1           dd          ?
hBtn2           dd          ?
hBtn3           dd          ?
MinimizeBmp     db          '.\min.bmp',0
MaximizeBmp     db          '.\max.bmp',0
CloseBmp        db          '.\close.bmp',0

.code
    start:
        invoke  GetModuleHandle,NULL
        mov hInstance,eax
        invoke  WinMain,hInstance,NULL,NULL,SW_SHOWNORMAL
        invoke  ExitProcess,eax

WinMain PROC    hInst:DWORD,hPInst:DWORD,CmdLine:DWORD,CmdShow:DWORD

    local   msg:MSG

    push    hInstance
    pop     wc.hInstance
    invoke  LoadIcon,NULL,IDI_APPLICATION
    mov     wc.hIcon,eax
    mov     wc.hIconSm,eax
    invoke  LoadCursor,NULL,IDC_ARROW
    mov     wc.hCursor,eax
    invoke  RegisterClassEx,addr wc
    invoke  GetSystemMetrics,SM_CYSCREEN
    shr     eax,1
    sub     eax,MainWindowHeight/2
    push    eax
    invoke  GetSystemMetrics,SM_CXSCREEN
    shr     eax,1
    sub     eax,MainWindowWidth/2
    pop     ebx
    invoke  CreateWindowEx,NULL,addr MainWindowClass,addr MainWindowName,WS_POPUP+WS_CLIPCHILDREN+WS_SIZEBOX,\   
               eax,ebx,MainWindowWidth,MainWindowHeight,NULL,NULL,hInstance,NULL
    mov     hMainWindow,eax
    invoke  ShowWindow,eax,CmdShow
    invoke  UpdateWindow,hMainWindow

msg_loop:
    invoke  PeekMessage,addr msg,NULL,0,0,PM_NOREMOVE
    or      eax,eax
    jz      no_msg
skippers:    
    invoke  GetMessage,addr msg,NULL,0,0
    or      eax,eax
    jz      end_msg_loop
    invoke  TranslateMessage,addr msg
    invoke  DispatchMessage,addr msg
    jmp     msg_loop
no_msg:
    cmp     StartUp,TRUE
    jne     skippers    
    invoke  SendMessage,hMainWindow,WM_USER,NULL,NULL
    mov     StartUp,FALSE
    jmp     skippers
end_msg_loop:
    mov     eax,msg.wParam
    ret

WinMain     endp

WndProc PROC    hWnd:DWORD,uMsg:DWORD,wParam:DWORD,lParam:DWORD

    local   ps:PAINTSTRUCT
    
    .if uMsg==WM_DESTROY
        invoke  PostQuitMessage,NULL
    .elseif uMsg==WM_CREATE
        mov     edi,lParam
        .if [edi.CREATESTRUCT].hWndParent==NULL
            invoke  LoadImage,hInstance,addr BarBitmap,IMAGE_BITMAP,NULL,NULL,LR_DEFAULTSIZE+LR_LOADFROMFILE
            mov     hBitmap,eax
            invoke  GetClientRect,hWnd,addr rect
            sub     rect.right,18*3+3
            invoke  CreateWindowEx,NULL,addr ButtonClass,NULL,BS_BTN,rect.right,3,18,18,\
                        hWnd,ID_MIN,hInstance,NULL
            mov     hBtn1,eax                        
            add     rect.right,18
            invoke  CreateWindowEx,NULL,addr ButtonClass,NULL,BS_BTN,rect.right,3,18,18,\
                        hWnd,ID_MAX,hInstance,NULL
            mov     hBtn2,eax                        
            add     rect.right,18            
            invoke  CreateWindowEx,NULL,addr ButtonClass,NULL,BS_BTN,rect.right,3,18,18,\
                        hWnd,ID_CLOSE,hInstance,NULL
            mov     hBtn3,eax                        
            invoke  LoadImage,hInstance,addr MinimizeBmp,IMAGE_BITMAP,16,16,LR_LOADFROMFILE
            invoke  SendMessage,hBtn1,BM_SETIMAGE,IMAGE_BITMAP,eax
            invoke  LoadImage,hInstance,addr MaximizeBmp,IMAGE_BITMAP,16,16,LR_LOADFROMFILE
            invoke  SendMessage,hBtn2,BM_SETIMAGE,IMAGE_BITMAP,eax
            invoke  LoadImage,hInstance,addr CloseBmp,IMAGE_BITMAP,16,16,LR_LOADFROMFILE
            invoke  SendMessage,hBtn3,BM_SETIMAGE,IMAGE_BITMAP,eax
            invoke  InvalidateRect,hWnd,0,0
        .endif            
    .elseif uMsg==WM_COMMAND
        mov     eax,wParam
        .if     ax==ID_MIN
            invoke  ShowWindow,hWnd,SW_MINIMIZE
        .elseif ax==ID_MAX
            invoke  ShowWindow,hWnd,SW_MAXIMIZE
        .elseif ax==ID_CLOSE
            invoke  PostQuitMessage,NULL
        .endif 
    .elseif uMsg==WM_SIZE
        movzx   eax,word ptr lParam
        sub     eax,(18*3)+3
        push    eax
        invoke  MoveWindow,hBtn1,eax,3,18,18,TRUE
        pop     eax
        add     eax,18
        push    eax
        invoke  MoveWindow,hBtn2,eax,3,18,18,TRUE
        pop     eax
        add     eax,18
        invoke  MoveWindow,hBtn3,eax,3,18,18,TRUE
        invoke  InvalidateRect,hWnd,0,0
        
    .elseif uMsg==WM_PAINT
        invoke  BeginPaint,hWnd,addr ps
        invoke  CreateCompatibleDC,ps.hdc
        mov     hMemDC,eax
        invoke  SelectObject,hMemDC,hBitmap
        sub     rect.right,4
        invoke  StretchBlt,ps.hdc,2,2,ps.rcPaint.right,20,hMemDC,0,0,400,32,SRCCOPY
        invoke  SetTextColor,ps.hdc,0ffffffh
        invoke  SendMessage,hWnd,WM_GETFONT,NULL,NULL
        invoke  SelectObject,ps.hdc,eax
        invoke  SetBkMode,ps.hdc,TRANSPARENT
        invoke  TextOut,ps.hdc,4,4,addr MainWindowName,sizeof MainWindowName
        invoke  DeleteDC,hMemDC
        invoke  EndPaint,hWnd,addr ps
    .else
        invoke  DefWindowProc,hWnd,uMsg,wParam,lParam
        ret
    .endif
    xor eax,eax
    ret

WndProc     endp

end start                                            
